/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.transform.PartitionInputMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PartitionInput
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> values;
    private Date lastAccessTime;
    private StorageDescriptor storageDescriptor;
    private Map<String, String> parameters;
    private Date lastAnalyzedTime;

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(Collection<String> values) {
        if (values == null) {
            this.values = null;
            return;
        }
        this.values = new ArrayList<String>(values);
    }

    public PartitionInput withValues(String ... values) {
        if (this.values == null) {
            this.setValues(new ArrayList<String>(values.length));
        }
        for (String ele : values) {
            this.values.add(ele);
        }
        return this;
    }

    public PartitionInput withValues(Collection<String> values) {
        this.setValues(values);
        return this;
    }

    public void setLastAccessTime(Date lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public Date getLastAccessTime() {
        return this.lastAccessTime;
    }

    public PartitionInput withLastAccessTime(Date lastAccessTime) {
        this.setLastAccessTime(lastAccessTime);
        return this;
    }

    public void setStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.storageDescriptor = storageDescriptor;
    }

    public StorageDescriptor getStorageDescriptor() {
        return this.storageDescriptor;
    }

    public PartitionInput withStorageDescriptor(StorageDescriptor storageDescriptor) {
        this.setStorageDescriptor(storageDescriptor);
        return this;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public PartitionInput withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    public PartitionInput addParametersEntry(String key, String value) {
        if (null == this.parameters) {
            this.parameters = new HashMap<String, String>();
        }
        if (this.parameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.parameters.put(key, value);
        return this;
    }

    public PartitionInput clearParametersEntries() {
        this.parameters = null;
        return this;
    }

    public void setLastAnalyzedTime(Date lastAnalyzedTime) {
        this.lastAnalyzedTime = lastAnalyzedTime;
    }

    public Date getLastAnalyzedTime() {
        return this.lastAnalyzedTime;
    }

    public PartitionInput withLastAnalyzedTime(Date lastAnalyzedTime) {
        this.setLastAnalyzedTime(lastAnalyzedTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValues() != null) {
            sb.append("Values: ").append(this.getValues()).append(",");
        }
        if (this.getLastAccessTime() != null) {
            sb.append("LastAccessTime: ").append(this.getLastAccessTime()).append(",");
        }
        if (this.getStorageDescriptor() != null) {
            sb.append("StorageDescriptor: ").append(this.getStorageDescriptor()).append(",");
        }
        if (this.getParameters() != null) {
            sb.append("Parameters: ").append(this.getParameters()).append(",");
        }
        if (this.getLastAnalyzedTime() != null) {
            sb.append("LastAnalyzedTime: ").append(this.getLastAnalyzedTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PartitionInput)) {
            return false;
        }
        PartitionInput other = (PartitionInput)obj;
        if (other.getValues() == null ^ this.getValues() == null) {
            return false;
        }
        if (other.getValues() != null && !other.getValues().equals(this.getValues())) {
            return false;
        }
        if (other.getLastAccessTime() == null ^ this.getLastAccessTime() == null) {
            return false;
        }
        if (other.getLastAccessTime() != null && !other.getLastAccessTime().equals(this.getLastAccessTime())) {
            return false;
        }
        if (other.getStorageDescriptor() == null ^ this.getStorageDescriptor() == null) {
            return false;
        }
        if (other.getStorageDescriptor() != null && !other.getStorageDescriptor().equals(this.getStorageDescriptor())) {
            return false;
        }
        if (other.getParameters() == null ^ this.getParameters() == null) {
            return false;
        }
        if (other.getParameters() != null && !other.getParameters().equals(this.getParameters())) {
            return false;
        }
        if (other.getLastAnalyzedTime() == null ^ this.getLastAnalyzedTime() == null) {
            return false;
        }
        return other.getLastAnalyzedTime() == null || other.getLastAnalyzedTime().equals(this.getLastAnalyzedTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValues() == null ? 0 : this.getValues().hashCode());
        hashCode = 31 * hashCode + (this.getLastAccessTime() == null ? 0 : this.getLastAccessTime().hashCode());
        hashCode = 31 * hashCode + (this.getStorageDescriptor() == null ? 0 : this.getStorageDescriptor().hashCode());
        hashCode = 31 * hashCode + (this.getParameters() == null ? 0 : this.getParameters().hashCode());
        hashCode = 31 * hashCode + (this.getLastAnalyzedTime() == null ? 0 : this.getLastAnalyzedTime().hashCode());
        return hashCode;
    }

    public PartitionInput clone() {
        try {
            return (PartitionInput)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PartitionInputMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

