/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.redshift.model.RevokeSnapshotAccessRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RevokeSnapshotAccessRequestMarshaller
implements Marshaller<Request<RevokeSnapshotAccessRequest>, RevokeSnapshotAccessRequest> {
    @Override
    public Request<RevokeSnapshotAccessRequest> marshall(RevokeSnapshotAccessRequest revokeSnapshotAccessRequest) {
        if (revokeSnapshotAccessRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RevokeSnapshotAccessRequest> request = new DefaultRequest<RevokeSnapshotAccessRequest>(revokeSnapshotAccessRequest, "AmazonRedshift");
        request.addParameter("Action", "RevokeSnapshotAccess");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSnapshotAccessRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString(revokeSnapshotAccessRequest.getSnapshotIdentifier()));
        }
        if (revokeSnapshotAccessRequest.getSnapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString(revokeSnapshotAccessRequest.getSnapshotClusterIdentifier()));
        }
        if (revokeSnapshotAccessRequest.getAccountWithRestoreAccess() != null) {
            request.addParameter("AccountWithRestoreAccess", StringUtils.fromString(revokeSnapshotAccessRequest.getAccountWithRestoreAccess()));
        }
        return request;
    }
}

