/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.importexport.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.importexport.model.CreateJobRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateJobRequestMarshaller
implements Marshaller<Request<CreateJobRequest>, CreateJobRequest> {
    @Override
    public Request<CreateJobRequest> marshall(CreateJobRequest createJobRequest) {
        if (createJobRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateJobRequest> request = new DefaultRequest<CreateJobRequest>(createJobRequest, "AmazonImportExport");
        request.addParameter("Action", "CreateJob");
        request.addParameter("Version", "2010-06-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createJobRequest.getJobType() != null) {
            request.addParameter("JobType", StringUtils.fromString(createJobRequest.getJobType()));
        }
        if (createJobRequest.getManifest() != null) {
            request.addParameter("Manifest", StringUtils.fromString(createJobRequest.getManifest()));
        }
        if (createJobRequest.getManifestAddendum() != null) {
            request.addParameter("ManifestAddendum", StringUtils.fromString(createJobRequest.getManifestAddendum()));
        }
        if (createJobRequest.getValidateOnly() != null) {
            request.addParameter("ValidateOnly", StringUtils.fromBoolean(createJobRequest.getValidateOnly()));
        }
        if (createJobRequest.getAPIVersion() != null) {
            request.addParameter("APIVersion", StringUtils.fromString(createJobRequest.getAPIVersion()));
        }
        return request;
    }
}

