/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.Application;
import java.util.Map;

public class ApplicationJsonMarshaller {
    private static ApplicationJsonMarshaller instance;

    public void marshall(Application application, StructuredJsonGenerator jsonGenerator) {
        if (application == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap additionalInfoMap;
            SdkInternalList argsList;
            jsonGenerator.writeStartObject();
            if (application.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(application.getName());
            }
            if (application.getVersion() != null) {
                jsonGenerator.writeFieldName("Version").writeValue(application.getVersion());
            }
            if (!(argsList = (SdkInternalList)application.getArgs()).isEmpty() || !argsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Args");
                jsonGenerator.writeStartArray();
                for (String argsListValue : argsList) {
                    if (argsListValue == null) continue;
                    jsonGenerator.writeValue(argsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(additionalInfoMap = (SdkInternalMap)application.getAdditionalInfo()).isEmpty() || !additionalInfoMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("AdditionalInfo");
                jsonGenerator.writeStartObject();
                for (Map.Entry additionalInfoMapValue : additionalInfoMap.entrySet()) {
                    if (additionalInfoMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)additionalInfoMapValue.getKey());
                    jsonGenerator.writeValue((String)additionalInfoMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ApplicationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ApplicationJsonMarshaller();
        }
        return instance;
    }
}

