/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.Volume;
import com.amazonaws.services.ecs.model.transform.HostVolumePropertiesJsonMarshaller;

public class VolumeJsonMarshaller {
    private static VolumeJsonMarshaller instance;

    public void marshall(Volume volume, StructuredJsonGenerator jsonGenerator) {
        if (volume == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (volume.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(volume.getName());
            }
            if (volume.getHost() != null) {
                jsonGenerator.writeFieldName("host");
                HostVolumePropertiesJsonMarshaller.getInstance().marshall(volume.getHost(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static VolumeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new VolumeJsonMarshaller();
        }
        return instance;
    }
}

