/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.adapters.types.StringToByteBufferAdapter;
import com.amazonaws.services.lambda.model.InvocationType;
import com.amazonaws.services.lambda.model.LogType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class InvokeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String functionName;
    private String invocationType;
    private String logType;
    private String clientContext;
    private ByteBuffer payload;
    private String qualifier;

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public InvokeRequest withFunctionName(String functionName) {
        this.setFunctionName(functionName);
        return this;
    }

    public void setInvocationType(String invocationType) {
        this.invocationType = invocationType;
    }

    @JsonProperty(value="invocationType")
    public String getInvocationType() {
        return this.invocationType;
    }

    public InvokeRequest withInvocationType(String invocationType) {
        this.setInvocationType(invocationType);
        return this;
    }

    @JsonIgnore
    public void setInvocationType(InvocationType invocationType) {
        this.withInvocationType(invocationType);
    }

    public InvokeRequest withInvocationType(InvocationType invocationType) {
        this.invocationType = invocationType.toString();
        return this;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    @JsonProperty(value="logType")
    public String getLogType() {
        return this.logType;
    }

    public InvokeRequest withLogType(String logType) {
        this.setLogType(logType);
        return this;
    }

    @JsonIgnore
    public void setLogType(LogType logType) {
        this.withLogType(logType);
    }

    public InvokeRequest withLogType(LogType logType) {
        this.logType = logType.toString();
        return this;
    }

    public void setClientContext(String clientContext) {
        this.clientContext = clientContext;
    }

    public String getClientContext() {
        return this.clientContext;
    }

    public InvokeRequest withClientContext(String clientContext) {
        this.setClientContext(clientContext);
        return this;
    }

    public void setPayload(ByteBuffer payload) {
        this.payload = payload;
    }

    public ByteBuffer getPayload() {
        return this.payload;
    }

    public InvokeRequest withPayload(ByteBuffer payload) {
        this.setPayload(payload);
        return this;
    }

    public void setPayload(String payload) {
        this.setPayload(new StringToByteBufferAdapter().adapt(payload));
    }

    public InvokeRequest withPayload(String payload) {
        this.setPayload(new StringToByteBufferAdapter().adapt(payload));
        return this;
    }

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public InvokeRequest withQualifier(String qualifier) {
        this.setQualifier(qualifier);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFunctionName() != null) {
            sb.append("FunctionName: ").append(this.getFunctionName()).append(",");
        }
        if (this.getInvocationType() != null) {
            sb.append("InvocationType: ").append(this.getInvocationType()).append(",");
        }
        if (this.getLogType() != null) {
            sb.append("LogType: ").append(this.getLogType()).append(",");
        }
        if (this.getClientContext() != null) {
            sb.append("ClientContext: ").append(this.getClientContext()).append(",");
        }
        if (this.getPayload() != null) {
            sb.append("Payload: ").append(this.getPayload()).append(",");
        }
        if (this.getQualifier() != null) {
            sb.append("Qualifier: ").append(this.getQualifier());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeRequest)) {
            return false;
        }
        InvokeRequest other = (InvokeRequest)obj;
        if (other.getFunctionName() == null ^ this.getFunctionName() == null) {
            return false;
        }
        if (other.getFunctionName() != null && !other.getFunctionName().equals(this.getFunctionName())) {
            return false;
        }
        if (other.getInvocationType() == null ^ this.getInvocationType() == null) {
            return false;
        }
        if (other.getInvocationType() != null && !other.getInvocationType().equals(this.getInvocationType())) {
            return false;
        }
        if (other.getLogType() == null ^ this.getLogType() == null) {
            return false;
        }
        if (other.getLogType() != null && !other.getLogType().equals(this.getLogType())) {
            return false;
        }
        if (other.getClientContext() == null ^ this.getClientContext() == null) {
            return false;
        }
        if (other.getClientContext() != null && !other.getClientContext().equals(this.getClientContext())) {
            return false;
        }
        if (other.getPayload() == null ^ this.getPayload() == null) {
            return false;
        }
        if (other.getPayload() != null && !other.getPayload().equals(this.getPayload())) {
            return false;
        }
        if (other.getQualifier() == null ^ this.getQualifier() == null) {
            return false;
        }
        return other.getQualifier() == null || other.getQualifier().equals(this.getQualifier());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFunctionName() == null ? 0 : this.getFunctionName().hashCode());
        hashCode = 31 * hashCode + (this.getInvocationType() == null ? 0 : this.getInvocationType().hashCode());
        hashCode = 31 * hashCode + (this.getLogType() == null ? 0 : this.getLogType().hashCode());
        hashCode = 31 * hashCode + (this.getClientContext() == null ? 0 : this.getClientContext().hashCode());
        hashCode = 31 * hashCode + (this.getPayload() == null ? 0 : this.getPayload().hashCode());
        hashCode = 31 * hashCode + (this.getQualifier() == null ? 0 : this.getQualifier().hashCode());
        return hashCode;
    }

    @Override
    public InvokeRequest clone() {
        return (InvokeRequest)super.clone();
    }
}

