/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.ConnectionType;
import com.amazonaws.services.glue.model.PhysicalConnectionRequirements;
import com.amazonaws.services.glue.model.transform.ConnectionMarshaller;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Connection
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private String connectionType;
    private List<String> matchCriteria;
    private Map<String, String> connectionProperties;
    private PhysicalConnectionRequirements physicalConnectionRequirements;
    private Date creationTime;
    private Date lastUpdatedTime;
    private String lastUpdatedBy;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Connection withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public Connection withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    @JsonProperty(value="connectionType")
    public String getConnectionType() {
        return this.connectionType;
    }

    public Connection withConnectionType(String connectionType) {
        this.setConnectionType(connectionType);
        return this;
    }

    public Connection withConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType.toString();
        return this;
    }

    public List<String> getMatchCriteria() {
        return this.matchCriteria;
    }

    public void setMatchCriteria(Collection<String> matchCriteria) {
        if (matchCriteria == null) {
            this.matchCriteria = null;
            return;
        }
        this.matchCriteria = new ArrayList<String>(matchCriteria);
    }

    public Connection withMatchCriteria(String ... matchCriteria) {
        if (this.matchCriteria == null) {
            this.setMatchCriteria(new ArrayList<String>(matchCriteria.length));
        }
        for (String ele : matchCriteria) {
            this.matchCriteria.add(ele);
        }
        return this;
    }

    public Connection withMatchCriteria(Collection<String> matchCriteria) {
        this.setMatchCriteria(matchCriteria);
        return this;
    }

    public Map<String, String> getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(Map<String, String> connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public Connection withConnectionProperties(Map<String, String> connectionProperties) {
        this.setConnectionProperties(connectionProperties);
        return this;
    }

    public Connection addConnectionPropertiesEntry(String key, String value) {
        if (null == this.connectionProperties) {
            this.connectionProperties = new HashMap<String, String>();
        }
        if (this.connectionProperties.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.connectionProperties.put(key, value);
        return this;
    }

    public Connection clearConnectionPropertiesEntries() {
        this.connectionProperties = null;
        return this;
    }

    public void setPhysicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
        this.physicalConnectionRequirements = physicalConnectionRequirements;
    }

    public PhysicalConnectionRequirements getPhysicalConnectionRequirements() {
        return this.physicalConnectionRequirements;
    }

    public Connection withPhysicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
        this.setPhysicalConnectionRequirements(physicalConnectionRequirements);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Connection withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setLastUpdatedTime(Date lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public Date getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Connection withLastUpdatedTime(Date lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public void setLastUpdatedBy(String lastUpdatedBy) {
        this.lastUpdatedBy = lastUpdatedBy;
    }

    public String getLastUpdatedBy() {
        return this.lastUpdatedBy;
    }

    public Connection withLastUpdatedBy(String lastUpdatedBy) {
        this.setLastUpdatedBy(lastUpdatedBy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getConnectionType() != null) {
            sb.append("ConnectionType: ").append(this.getConnectionType()).append(",");
        }
        if (this.getMatchCriteria() != null) {
            sb.append("MatchCriteria: ").append(this.getMatchCriteria()).append(",");
        }
        if (this.getConnectionProperties() != null) {
            sb.append("ConnectionProperties: ").append(this.getConnectionProperties()).append(",");
        }
        if (this.getPhysicalConnectionRequirements() != null) {
            sb.append("PhysicalConnectionRequirements: ").append(this.getPhysicalConnectionRequirements()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getLastUpdatedBy() != null) {
            sb.append("LastUpdatedBy: ").append(this.getLastUpdatedBy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getConnectionType() == null ^ this.getConnectionType() == null) {
            return false;
        }
        if (other.getConnectionType() != null && !other.getConnectionType().equals(this.getConnectionType())) {
            return false;
        }
        if (other.getMatchCriteria() == null ^ this.getMatchCriteria() == null) {
            return false;
        }
        if (other.getMatchCriteria() != null && !other.getMatchCriteria().equals(this.getMatchCriteria())) {
            return false;
        }
        if (other.getConnectionProperties() == null ^ this.getConnectionProperties() == null) {
            return false;
        }
        if (other.getConnectionProperties() != null && !other.getConnectionProperties().equals(this.getConnectionProperties())) {
            return false;
        }
        if (other.getPhysicalConnectionRequirements() == null ^ this.getPhysicalConnectionRequirements() == null) {
            return false;
        }
        if (other.getPhysicalConnectionRequirements() != null && !other.getPhysicalConnectionRequirements().equals(this.getPhysicalConnectionRequirements())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getLastUpdatedBy() == null ^ this.getLastUpdatedBy() == null) {
            return false;
        }
        return other.getLastUpdatedBy() == null || other.getLastUpdatedBy().equals(this.getLastUpdatedBy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionType() == null ? 0 : this.getConnectionType().hashCode());
        hashCode = 31 * hashCode + (this.getMatchCriteria() == null ? 0 : this.getMatchCriteria().hashCode());
        hashCode = 31 * hashCode + (this.getConnectionProperties() == null ? 0 : this.getConnectionProperties().hashCode());
        hashCode = 31 * hashCode + (this.getPhysicalConnectionRequirements() == null ? 0 : this.getPhysicalConnectionRequirements().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedBy() == null ? 0 : this.getLastUpdatedBy().hashCode());
        return hashCode;
    }

    public Connection clone() {
        try {
            return (Connection)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

