/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.databasemigrationservice.model.MigrationTypeValue;
import com.amazonaws.services.databasemigrationservice.model.Tag;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class CreateReplicationTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String replicationTaskIdentifier;
    private String sourceEndpointArn;
    private String targetEndpointArn;
    private String replicationInstanceArn;
    private String migrationType;
    private String tableMappings;
    private String replicationTaskSettings;
    private Date cdcStartTime;
    private List<Tag> tags;

    public void setReplicationTaskIdentifier(String replicationTaskIdentifier) {
        this.replicationTaskIdentifier = replicationTaskIdentifier;
    }

    public String getReplicationTaskIdentifier() {
        return this.replicationTaskIdentifier;
    }

    public CreateReplicationTaskRequest withReplicationTaskIdentifier(String replicationTaskIdentifier) {
        this.setReplicationTaskIdentifier(replicationTaskIdentifier);
        return this;
    }

    public void setSourceEndpointArn(String sourceEndpointArn) {
        this.sourceEndpointArn = sourceEndpointArn;
    }

    public String getSourceEndpointArn() {
        return this.sourceEndpointArn;
    }

    public CreateReplicationTaskRequest withSourceEndpointArn(String sourceEndpointArn) {
        this.setSourceEndpointArn(sourceEndpointArn);
        return this;
    }

    public void setTargetEndpointArn(String targetEndpointArn) {
        this.targetEndpointArn = targetEndpointArn;
    }

    public String getTargetEndpointArn() {
        return this.targetEndpointArn;
    }

    public CreateReplicationTaskRequest withTargetEndpointArn(String targetEndpointArn) {
        this.setTargetEndpointArn(targetEndpointArn);
        return this;
    }

    public void setReplicationInstanceArn(String replicationInstanceArn) {
        this.replicationInstanceArn = replicationInstanceArn;
    }

    public String getReplicationInstanceArn() {
        return this.replicationInstanceArn;
    }

    public CreateReplicationTaskRequest withReplicationInstanceArn(String replicationInstanceArn) {
        this.setReplicationInstanceArn(replicationInstanceArn);
        return this;
    }

    public void setMigrationType(String migrationType) {
        this.migrationType = migrationType;
    }

    @JsonProperty(value="migrationType")
    public String getMigrationType() {
        return this.migrationType;
    }

    public CreateReplicationTaskRequest withMigrationType(String migrationType) {
        this.setMigrationType(migrationType);
        return this;
    }

    @JsonIgnore
    public void setMigrationType(MigrationTypeValue migrationType) {
        this.withMigrationType(migrationType);
    }

    public CreateReplicationTaskRequest withMigrationType(MigrationTypeValue migrationType) {
        this.migrationType = migrationType.toString();
        return this;
    }

    public void setTableMappings(String tableMappings) {
        this.tableMappings = tableMappings;
    }

    public String getTableMappings() {
        return this.tableMappings;
    }

    public CreateReplicationTaskRequest withTableMappings(String tableMappings) {
        this.setTableMappings(tableMappings);
        return this;
    }

    public void setReplicationTaskSettings(String replicationTaskSettings) {
        this.replicationTaskSettings = replicationTaskSettings;
    }

    public String getReplicationTaskSettings() {
        return this.replicationTaskSettings;
    }

    public CreateReplicationTaskRequest withReplicationTaskSettings(String replicationTaskSettings) {
        this.setReplicationTaskSettings(replicationTaskSettings);
        return this;
    }

    public void setCdcStartTime(Date cdcStartTime) {
        this.cdcStartTime = cdcStartTime;
    }

    public Date getCdcStartTime() {
        return this.cdcStartTime;
    }

    public CreateReplicationTaskRequest withCdcStartTime(Date cdcStartTime) {
        this.setCdcStartTime(cdcStartTime);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateReplicationTaskRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateReplicationTaskRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationTaskIdentifier() != null) {
            sb.append("ReplicationTaskIdentifier: ").append(this.getReplicationTaskIdentifier()).append(",");
        }
        if (this.getSourceEndpointArn() != null) {
            sb.append("SourceEndpointArn: ").append(this.getSourceEndpointArn()).append(",");
        }
        if (this.getTargetEndpointArn() != null) {
            sb.append("TargetEndpointArn: ").append(this.getTargetEndpointArn()).append(",");
        }
        if (this.getReplicationInstanceArn() != null) {
            sb.append("ReplicationInstanceArn: ").append(this.getReplicationInstanceArn()).append(",");
        }
        if (this.getMigrationType() != null) {
            sb.append("MigrationType: ").append(this.getMigrationType()).append(",");
        }
        if (this.getTableMappings() != null) {
            sb.append("TableMappings: ").append(this.getTableMappings()).append(",");
        }
        if (this.getReplicationTaskSettings() != null) {
            sb.append("ReplicationTaskSettings: ").append(this.getReplicationTaskSettings()).append(",");
        }
        if (this.getCdcStartTime() != null) {
            sb.append("CdcStartTime: ").append(this.getCdcStartTime()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReplicationTaskRequest)) {
            return false;
        }
        CreateReplicationTaskRequest other = (CreateReplicationTaskRequest)obj;
        if (other.getReplicationTaskIdentifier() == null ^ this.getReplicationTaskIdentifier() == null) {
            return false;
        }
        if (other.getReplicationTaskIdentifier() != null && !other.getReplicationTaskIdentifier().equals(this.getReplicationTaskIdentifier())) {
            return false;
        }
        if (other.getSourceEndpointArn() == null ^ this.getSourceEndpointArn() == null) {
            return false;
        }
        if (other.getSourceEndpointArn() != null && !other.getSourceEndpointArn().equals(this.getSourceEndpointArn())) {
            return false;
        }
        if (other.getTargetEndpointArn() == null ^ this.getTargetEndpointArn() == null) {
            return false;
        }
        if (other.getTargetEndpointArn() != null && !other.getTargetEndpointArn().equals(this.getTargetEndpointArn())) {
            return false;
        }
        if (other.getReplicationInstanceArn() == null ^ this.getReplicationInstanceArn() == null) {
            return false;
        }
        if (other.getReplicationInstanceArn() != null && !other.getReplicationInstanceArn().equals(this.getReplicationInstanceArn())) {
            return false;
        }
        if (other.getMigrationType() == null ^ this.getMigrationType() == null) {
            return false;
        }
        if (other.getMigrationType() != null && !other.getMigrationType().equals(this.getMigrationType())) {
            return false;
        }
        if (other.getTableMappings() == null ^ this.getTableMappings() == null) {
            return false;
        }
        if (other.getTableMappings() != null && !other.getTableMappings().equals(this.getTableMappings())) {
            return false;
        }
        if (other.getReplicationTaskSettings() == null ^ this.getReplicationTaskSettings() == null) {
            return false;
        }
        if (other.getReplicationTaskSettings() != null && !other.getReplicationTaskSettings().equals(this.getReplicationTaskSettings())) {
            return false;
        }
        if (other.getCdcStartTime() == null ^ this.getCdcStartTime() == null) {
            return false;
        }
        if (other.getCdcStartTime() != null && !other.getCdcStartTime().equals(this.getCdcStartTime())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationTaskIdentifier() == null ? 0 : this.getReplicationTaskIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getSourceEndpointArn() == null ? 0 : this.getSourceEndpointArn().hashCode());
        hashCode = 31 * hashCode + (this.getTargetEndpointArn() == null ? 0 : this.getTargetEndpointArn().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationInstanceArn() == null ? 0 : this.getReplicationInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getMigrationType() == null ? 0 : this.getMigrationType().hashCode());
        hashCode = 31 * hashCode + (this.getTableMappings() == null ? 0 : this.getTableMappings().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationTaskSettings() == null ? 0 : this.getReplicationTaskSettings().hashCode());
        hashCode = 31 * hashCode + (this.getCdcStartTime() == null ? 0 : this.getCdcStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateReplicationTaskRequest clone() {
        return (CreateReplicationTaskRequest)super.clone();
    }
}

