/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidp.model.AuthFlowType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class AdminInitiateAuthRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String userPoolId;
    private String clientId;
    private String authFlow;
    private Map<String, String> authParameters;
    private Map<String, String> clientMetadata;

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public AdminInitiateAuthRequest withUserPoolId(String userPoolId) {
        this.setUserPoolId(userPoolId);
        return this;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public AdminInitiateAuthRequest withClientId(String clientId) {
        this.setClientId(clientId);
        return this;
    }

    public void setAuthFlow(String authFlow) {
        this.authFlow = authFlow;
    }

    @JsonProperty(value="authFlow")
    public String getAuthFlow() {
        return this.authFlow;
    }

    public AdminInitiateAuthRequest withAuthFlow(String authFlow) {
        this.setAuthFlow(authFlow);
        return this;
    }

    @JsonIgnore
    public void setAuthFlow(AuthFlowType authFlow) {
        this.withAuthFlow(authFlow);
    }

    public AdminInitiateAuthRequest withAuthFlow(AuthFlowType authFlow) {
        this.authFlow = authFlow.toString();
        return this;
    }

    public Map<String, String> getAuthParameters() {
        return this.authParameters;
    }

    public void setAuthParameters(Map<String, String> authParameters) {
        this.authParameters = authParameters;
    }

    public AdminInitiateAuthRequest withAuthParameters(Map<String, String> authParameters) {
        this.setAuthParameters(authParameters);
        return this;
    }

    public AdminInitiateAuthRequest addAuthParametersEntry(String key, String value) {
        if (null == this.authParameters) {
            this.authParameters = new HashMap<String, String>();
        }
        if (this.authParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.authParameters.put(key, value);
        return this;
    }

    public AdminInitiateAuthRequest clearAuthParametersEntries() {
        this.authParameters = null;
        return this;
    }

    public Map<String, String> getClientMetadata() {
        return this.clientMetadata;
    }

    public void setClientMetadata(Map<String, String> clientMetadata) {
        this.clientMetadata = clientMetadata;
    }

    public AdminInitiateAuthRequest withClientMetadata(Map<String, String> clientMetadata) {
        this.setClientMetadata(clientMetadata);
        return this;
    }

    public AdminInitiateAuthRequest addClientMetadataEntry(String key, String value) {
        if (null == this.clientMetadata) {
            this.clientMetadata = new HashMap<String, String>();
        }
        if (this.clientMetadata.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.clientMetadata.put(key, value);
        return this;
    }

    public AdminInitiateAuthRequest clearClientMetadataEntries() {
        this.clientMetadata = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: ").append(this.getUserPoolId()).append(",");
        }
        if (this.getClientId() != null) {
            sb.append("ClientId: ").append(this.getClientId()).append(",");
        }
        if (this.getAuthFlow() != null) {
            sb.append("AuthFlow: ").append(this.getAuthFlow()).append(",");
        }
        if (this.getAuthParameters() != null) {
            sb.append("AuthParameters: ").append(this.getAuthParameters()).append(",");
        }
        if (this.getClientMetadata() != null) {
            sb.append("ClientMetadata: ").append(this.getClientMetadata());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminInitiateAuthRequest)) {
            return false;
        }
        AdminInitiateAuthRequest other = (AdminInitiateAuthRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getClientId() == null ^ this.getClientId() == null) {
            return false;
        }
        if (other.getClientId() != null && !other.getClientId().equals(this.getClientId())) {
            return false;
        }
        if (other.getAuthFlow() == null ^ this.getAuthFlow() == null) {
            return false;
        }
        if (other.getAuthFlow() != null && !other.getAuthFlow().equals(this.getAuthFlow())) {
            return false;
        }
        if (other.getAuthParameters() == null ^ this.getAuthParameters() == null) {
            return false;
        }
        if (other.getAuthParameters() != null && !other.getAuthParameters().equals(this.getAuthParameters())) {
            return false;
        }
        if (other.getClientMetadata() == null ^ this.getClientMetadata() == null) {
            return false;
        }
        return other.getClientMetadata() == null || other.getClientMetadata().equals(this.getClientMetadata());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getClientId() == null ? 0 : this.getClientId().hashCode());
        hashCode = 31 * hashCode + (this.getAuthFlow() == null ? 0 : this.getAuthFlow().hashCode());
        hashCode = 31 * hashCode + (this.getAuthParameters() == null ? 0 : this.getAuthParameters().hashCode());
        hashCode = 31 * hashCode + (this.getClientMetadata() == null ? 0 : this.getClientMetadata().hashCode());
        return hashCode;
    }

    @Override
    public AdminInitiateAuthRequest clone() {
        return (AdminInitiateAuthRequest)super.clone();
    }
}

