/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationautoscaling.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.applicationautoscaling.model.AdjustmentType;
import com.amazonaws.services.applicationautoscaling.model.MetricAggregationType;
import com.amazonaws.services.applicationautoscaling.model.StepAdjustment;
import com.amazonaws.services.applicationautoscaling.model.transform.StepScalingPolicyConfigurationMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StepScalingPolicyConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String adjustmentType;
    private List<StepAdjustment> stepAdjustments;
    private Integer minAdjustmentMagnitude;
    private Integer cooldown;
    private String metricAggregationType;

    public void setAdjustmentType(String adjustmentType) {
        this.adjustmentType = adjustmentType;
    }

    @JsonProperty(value="adjustmentType")
    public String getAdjustmentType() {
        return this.adjustmentType;
    }

    public StepScalingPolicyConfiguration withAdjustmentType(String adjustmentType) {
        this.setAdjustmentType(adjustmentType);
        return this;
    }

    @JsonIgnore
    public void setAdjustmentType(AdjustmentType adjustmentType) {
        this.withAdjustmentType(adjustmentType);
    }

    public StepScalingPolicyConfiguration withAdjustmentType(AdjustmentType adjustmentType) {
        this.adjustmentType = adjustmentType.toString();
        return this;
    }

    public List<StepAdjustment> getStepAdjustments() {
        return this.stepAdjustments;
    }

    public void setStepAdjustments(Collection<StepAdjustment> stepAdjustments) {
        if (stepAdjustments == null) {
            this.stepAdjustments = null;
            return;
        }
        this.stepAdjustments = new ArrayList<StepAdjustment>(stepAdjustments);
    }

    public StepScalingPolicyConfiguration withStepAdjustments(StepAdjustment ... stepAdjustments) {
        if (this.stepAdjustments == null) {
            this.setStepAdjustments(new ArrayList<StepAdjustment>(stepAdjustments.length));
        }
        for (StepAdjustment ele : stepAdjustments) {
            this.stepAdjustments.add(ele);
        }
        return this;
    }

    public StepScalingPolicyConfiguration withStepAdjustments(Collection<StepAdjustment> stepAdjustments) {
        this.setStepAdjustments(stepAdjustments);
        return this;
    }

    public void setMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
        this.minAdjustmentMagnitude = minAdjustmentMagnitude;
    }

    public Integer getMinAdjustmentMagnitude() {
        return this.minAdjustmentMagnitude;
    }

    public StepScalingPolicyConfiguration withMinAdjustmentMagnitude(Integer minAdjustmentMagnitude) {
        this.setMinAdjustmentMagnitude(minAdjustmentMagnitude);
        return this;
    }

    public void setCooldown(Integer cooldown) {
        this.cooldown = cooldown;
    }

    public Integer getCooldown() {
        return this.cooldown;
    }

    public StepScalingPolicyConfiguration withCooldown(Integer cooldown) {
        this.setCooldown(cooldown);
        return this;
    }

    public void setMetricAggregationType(String metricAggregationType) {
        this.metricAggregationType = metricAggregationType;
    }

    @JsonProperty(value="metricAggregationType")
    public String getMetricAggregationType() {
        return this.metricAggregationType;
    }

    public StepScalingPolicyConfiguration withMetricAggregationType(String metricAggregationType) {
        this.setMetricAggregationType(metricAggregationType);
        return this;
    }

    @JsonIgnore
    public void setMetricAggregationType(MetricAggregationType metricAggregationType) {
        this.withMetricAggregationType(metricAggregationType);
    }

    public StepScalingPolicyConfiguration withMetricAggregationType(MetricAggregationType metricAggregationType) {
        this.metricAggregationType = metricAggregationType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdjustmentType() != null) {
            sb.append("AdjustmentType: ").append(this.getAdjustmentType()).append(",");
        }
        if (this.getStepAdjustments() != null) {
            sb.append("StepAdjustments: ").append(this.getStepAdjustments()).append(",");
        }
        if (this.getMinAdjustmentMagnitude() != null) {
            sb.append("MinAdjustmentMagnitude: ").append(this.getMinAdjustmentMagnitude()).append(",");
        }
        if (this.getCooldown() != null) {
            sb.append("Cooldown: ").append(this.getCooldown()).append(",");
        }
        if (this.getMetricAggregationType() != null) {
            sb.append("MetricAggregationType: ").append(this.getMetricAggregationType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepScalingPolicyConfiguration)) {
            return false;
        }
        StepScalingPolicyConfiguration other = (StepScalingPolicyConfiguration)obj;
        if (other.getAdjustmentType() == null ^ this.getAdjustmentType() == null) {
            return false;
        }
        if (other.getAdjustmentType() != null && !other.getAdjustmentType().equals(this.getAdjustmentType())) {
            return false;
        }
        if (other.getStepAdjustments() == null ^ this.getStepAdjustments() == null) {
            return false;
        }
        if (other.getStepAdjustments() != null && !other.getStepAdjustments().equals(this.getStepAdjustments())) {
            return false;
        }
        if (other.getMinAdjustmentMagnitude() == null ^ this.getMinAdjustmentMagnitude() == null) {
            return false;
        }
        if (other.getMinAdjustmentMagnitude() != null && !other.getMinAdjustmentMagnitude().equals(this.getMinAdjustmentMagnitude())) {
            return false;
        }
        if (other.getCooldown() == null ^ this.getCooldown() == null) {
            return false;
        }
        if (other.getCooldown() != null && !other.getCooldown().equals(this.getCooldown())) {
            return false;
        }
        if (other.getMetricAggregationType() == null ^ this.getMetricAggregationType() == null) {
            return false;
        }
        return other.getMetricAggregationType() == null || other.getMetricAggregationType().equals(this.getMetricAggregationType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdjustmentType() == null ? 0 : this.getAdjustmentType().hashCode());
        hashCode = 31 * hashCode + (this.getStepAdjustments() == null ? 0 : this.getStepAdjustments().hashCode());
        hashCode = 31 * hashCode + (this.getMinAdjustmentMagnitude() == null ? 0 : this.getMinAdjustmentMagnitude().hashCode());
        hashCode = 31 * hashCode + (this.getCooldown() == null ? 0 : this.getCooldown().hashCode());
        hashCode = 31 * hashCode + (this.getMetricAggregationType() == null ? 0 : this.getMetricAggregationType().hashCode());
        return hashCode;
    }

    public StepScalingPolicyConfiguration clone() {
        try {
            return (StepScalingPolicyConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StepScalingPolicyConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

