/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.greengrass.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.greengrass.model.Subscription;
import com.amazonaws.services.greengrass.model.transform.SubscriptionDefinitionVersionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SubscriptionDefinitionVersion
implements Serializable,
Cloneable,
StructuredPojo {
    private List<Subscription> subscriptions;

    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(Collection<Subscription> subscriptions) {
        if (subscriptions == null) {
            this.subscriptions = null;
            return;
        }
        this.subscriptions = new ArrayList<Subscription>(subscriptions);
    }

    public SubscriptionDefinitionVersion withSubscriptions(Subscription ... subscriptions) {
        if (this.subscriptions == null) {
            this.setSubscriptions(new ArrayList<Subscription>(subscriptions.length));
        }
        for (Subscription ele : subscriptions) {
            this.subscriptions.add(ele);
        }
        return this;
    }

    public SubscriptionDefinitionVersion withSubscriptions(Collection<Subscription> subscriptions) {
        this.setSubscriptions(subscriptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubscriptions() != null) {
            sb.append("Subscriptions: ").append(this.getSubscriptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscriptionDefinitionVersion)) {
            return false;
        }
        SubscriptionDefinitionVersion other = (SubscriptionDefinitionVersion)obj;
        if (other.getSubscriptions() == null ^ this.getSubscriptions() == null) {
            return false;
        }
        return other.getSubscriptions() == null || other.getSubscriptions().equals(this.getSubscriptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubscriptions() == null ? 0 : this.getSubscriptions().hashCode());
        return hashCode;
    }

    public SubscriptionDefinitionVersion clone() {
        try {
            return (SubscriptionDefinitionVersion)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SubscriptionDefinitionVersionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

