/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.route53domains.model.OperationType;
import com.amazonaws.services.route53domains.model.transform.BillingRecordMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;

public class BillingRecord
implements Serializable,
Cloneable,
StructuredPojo {
    private String domainName;
    private String operation;
    private String invoiceId;
    private Date billDate;
    private Double price;

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public BillingRecord withDomainName(String domainName) {
        this.setDomainName(domainName);
        return this;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @JsonProperty(value="operation")
    public String getOperation() {
        return this.operation;
    }

    public BillingRecord withOperation(String operation) {
        this.setOperation(operation);
        return this;
    }

    @JsonIgnore
    public void setOperation(OperationType operation) {
        this.withOperation(operation);
    }

    public BillingRecord withOperation(OperationType operation) {
        this.operation = operation.toString();
        return this;
    }

    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public BillingRecord withInvoiceId(String invoiceId) {
        this.setInvoiceId(invoiceId);
        return this;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Date getBillDate() {
        return this.billDate;
    }

    public BillingRecord withBillDate(Date billDate) {
        this.setBillDate(billDate);
        return this;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Double getPrice() {
        return this.price;
    }

    public BillingRecord withPrice(Double price) {
        this.setPrice(price);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDomainName() != null) {
            sb.append("DomainName: ").append(this.getDomainName()).append(",");
        }
        if (this.getOperation() != null) {
            sb.append("Operation: ").append(this.getOperation()).append(",");
        }
        if (this.getInvoiceId() != null) {
            sb.append("InvoiceId: ").append(this.getInvoiceId()).append(",");
        }
        if (this.getBillDate() != null) {
            sb.append("BillDate: ").append(this.getBillDate()).append(",");
        }
        if (this.getPrice() != null) {
            sb.append("Price: ").append(this.getPrice());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillingRecord)) {
            return false;
        }
        BillingRecord other = (BillingRecord)obj;
        if (other.getDomainName() == null ^ this.getDomainName() == null) {
            return false;
        }
        if (other.getDomainName() != null && !other.getDomainName().equals(this.getDomainName())) {
            return false;
        }
        if (other.getOperation() == null ^ this.getOperation() == null) {
            return false;
        }
        if (other.getOperation() != null && !other.getOperation().equals(this.getOperation())) {
            return false;
        }
        if (other.getInvoiceId() == null ^ this.getInvoiceId() == null) {
            return false;
        }
        if (other.getInvoiceId() != null && !other.getInvoiceId().equals(this.getInvoiceId())) {
            return false;
        }
        if (other.getBillDate() == null ^ this.getBillDate() == null) {
            return false;
        }
        if (other.getBillDate() != null && !other.getBillDate().equals(this.getBillDate())) {
            return false;
        }
        if (other.getPrice() == null ^ this.getPrice() == null) {
            return false;
        }
        return other.getPrice() == null || other.getPrice().equals(this.getPrice());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDomainName() == null ? 0 : this.getDomainName().hashCode());
        hashCode = 31 * hashCode + (this.getOperation() == null ? 0 : this.getOperation().hashCode());
        hashCode = 31 * hashCode + (this.getInvoiceId() == null ? 0 : this.getInvoiceId().hashCode());
        hashCode = 31 * hashCode + (this.getBillDate() == null ? 0 : this.getBillDate().hashCode());
        hashCode = 31 * hashCode + (this.getPrice() == null ? 0 : this.getPrice().hashCode());
        return hashCode;
    }

    public BillingRecord clone() {
        try {
            return (BillingRecord)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BillingRecordMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

