/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rekognition.model.LandmarkType;
import com.amazonaws.services.rekognition.model.transform.LandmarkMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class Landmark
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private Float x;
    private Float y;

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public Landmark withType(String type) {
        this.setType(type);
        return this;
    }

    @JsonIgnore
    public void setType(LandmarkType type) {
        this.withType(type);
    }

    public Landmark withType(LandmarkType type) {
        this.type = type.toString();
        return this;
    }

    public void setX(Float x) {
        this.x = x;
    }

    public Float getX() {
        return this.x;
    }

    public Landmark withX(Float x) {
        this.setX(x);
        return this;
    }

    public void setY(Float y) {
        this.y = y;
    }

    public Float getY() {
        return this.y;
    }

    public Landmark withY(Float y) {
        this.setY(y);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getX() != null) {
            sb.append("X: ").append(this.getX()).append(",");
        }
        if (this.getY() != null) {
            sb.append("Y: ").append(this.getY());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Landmark)) {
            return false;
        }
        Landmark other = (Landmark)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getX() == null ^ this.getX() == null) {
            return false;
        }
        if (other.getX() != null && !other.getX().equals(this.getX())) {
            return false;
        }
        if (other.getY() == null ^ this.getY() == null) {
            return false;
        }
        return other.getY() == null || other.getY().equals(this.getY());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getX() == null ? 0 : this.getX().hashCode());
        hashCode = 31 * hashCode + (this.getY() == null ? 0 : this.getY().hashCode());
        return hashCode;
    }

    public Landmark clone() {
        try {
            return (Landmark)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LandmarkMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

