/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.organizations;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.organizations.AWSOrganizationsAsync;
import com.amazonaws.services.organizations.AWSOrganizationsAsyncClientBuilder;
import com.amazonaws.services.organizations.AWSOrganizationsClient;
import com.amazonaws.services.organizations.model.AcceptHandshakeRequest;
import com.amazonaws.services.organizations.model.AcceptHandshakeResult;
import com.amazonaws.services.organizations.model.AttachPolicyRequest;
import com.amazonaws.services.organizations.model.AttachPolicyResult;
import com.amazonaws.services.organizations.model.CancelHandshakeRequest;
import com.amazonaws.services.organizations.model.CancelHandshakeResult;
import com.amazonaws.services.organizations.model.CreateAccountRequest;
import com.amazonaws.services.organizations.model.CreateAccountResult;
import com.amazonaws.services.organizations.model.CreateOrganizationRequest;
import com.amazonaws.services.organizations.model.CreateOrganizationResult;
import com.amazonaws.services.organizations.model.CreateOrganizationalUnitRequest;
import com.amazonaws.services.organizations.model.CreateOrganizationalUnitResult;
import com.amazonaws.services.organizations.model.CreatePolicyRequest;
import com.amazonaws.services.organizations.model.CreatePolicyResult;
import com.amazonaws.services.organizations.model.DeclineHandshakeRequest;
import com.amazonaws.services.organizations.model.DeclineHandshakeResult;
import com.amazonaws.services.organizations.model.DeleteOrganizationRequest;
import com.amazonaws.services.organizations.model.DeleteOrganizationResult;
import com.amazonaws.services.organizations.model.DeleteOrganizationalUnitRequest;
import com.amazonaws.services.organizations.model.DeleteOrganizationalUnitResult;
import com.amazonaws.services.organizations.model.DeletePolicyRequest;
import com.amazonaws.services.organizations.model.DeletePolicyResult;
import com.amazonaws.services.organizations.model.DescribeAccountRequest;
import com.amazonaws.services.organizations.model.DescribeAccountResult;
import com.amazonaws.services.organizations.model.DescribeCreateAccountStatusRequest;
import com.amazonaws.services.organizations.model.DescribeCreateAccountStatusResult;
import com.amazonaws.services.organizations.model.DescribeHandshakeRequest;
import com.amazonaws.services.organizations.model.DescribeHandshakeResult;
import com.amazonaws.services.organizations.model.DescribeOrganizationRequest;
import com.amazonaws.services.organizations.model.DescribeOrganizationResult;
import com.amazonaws.services.organizations.model.DescribeOrganizationalUnitRequest;
import com.amazonaws.services.organizations.model.DescribeOrganizationalUnitResult;
import com.amazonaws.services.organizations.model.DescribePolicyRequest;
import com.amazonaws.services.organizations.model.DescribePolicyResult;
import com.amazonaws.services.organizations.model.DetachPolicyRequest;
import com.amazonaws.services.organizations.model.DetachPolicyResult;
import com.amazonaws.services.organizations.model.DisablePolicyTypeRequest;
import com.amazonaws.services.organizations.model.DisablePolicyTypeResult;
import com.amazonaws.services.organizations.model.EnableAllFeaturesRequest;
import com.amazonaws.services.organizations.model.EnableAllFeaturesResult;
import com.amazonaws.services.organizations.model.EnablePolicyTypeRequest;
import com.amazonaws.services.organizations.model.EnablePolicyTypeResult;
import com.amazonaws.services.organizations.model.InviteAccountToOrganizationRequest;
import com.amazonaws.services.organizations.model.InviteAccountToOrganizationResult;
import com.amazonaws.services.organizations.model.LeaveOrganizationRequest;
import com.amazonaws.services.organizations.model.LeaveOrganizationResult;
import com.amazonaws.services.organizations.model.ListAccountsForParentRequest;
import com.amazonaws.services.organizations.model.ListAccountsForParentResult;
import com.amazonaws.services.organizations.model.ListAccountsRequest;
import com.amazonaws.services.organizations.model.ListAccountsResult;
import com.amazonaws.services.organizations.model.ListChildrenRequest;
import com.amazonaws.services.organizations.model.ListChildrenResult;
import com.amazonaws.services.organizations.model.ListCreateAccountStatusRequest;
import com.amazonaws.services.organizations.model.ListCreateAccountStatusResult;
import com.amazonaws.services.organizations.model.ListHandshakesForAccountRequest;
import com.amazonaws.services.organizations.model.ListHandshakesForAccountResult;
import com.amazonaws.services.organizations.model.ListHandshakesForOrganizationRequest;
import com.amazonaws.services.organizations.model.ListHandshakesForOrganizationResult;
import com.amazonaws.services.organizations.model.ListOrganizationalUnitsForParentRequest;
import com.amazonaws.services.organizations.model.ListOrganizationalUnitsForParentResult;
import com.amazonaws.services.organizations.model.ListParentsRequest;
import com.amazonaws.services.organizations.model.ListParentsResult;
import com.amazonaws.services.organizations.model.ListPoliciesForTargetRequest;
import com.amazonaws.services.organizations.model.ListPoliciesForTargetResult;
import com.amazonaws.services.organizations.model.ListPoliciesRequest;
import com.amazonaws.services.organizations.model.ListPoliciesResult;
import com.amazonaws.services.organizations.model.ListRootsRequest;
import com.amazonaws.services.organizations.model.ListRootsResult;
import com.amazonaws.services.organizations.model.ListTargetsForPolicyRequest;
import com.amazonaws.services.organizations.model.ListTargetsForPolicyResult;
import com.amazonaws.services.organizations.model.MoveAccountRequest;
import com.amazonaws.services.organizations.model.MoveAccountResult;
import com.amazonaws.services.organizations.model.RemoveAccountFromOrganizationRequest;
import com.amazonaws.services.organizations.model.RemoveAccountFromOrganizationResult;
import com.amazonaws.services.organizations.model.UpdateOrganizationalUnitRequest;
import com.amazonaws.services.organizations.model.UpdateOrganizationalUnitResult;
import com.amazonaws.services.organizations.model.UpdatePolicyRequest;
import com.amazonaws.services.organizations.model.UpdatePolicyResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSOrganizationsAsyncClient
extends AWSOrganizationsClient
implements AWSOrganizationsAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSOrganizationsAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSOrganizationsAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSOrganizationsAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSOrganizationsAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSOrganizationsAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSOrganizationsAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSOrganizationsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSOrganizationsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSOrganizationsAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSOrganizationsAsyncClientBuilder asyncBuilder() {
        return AWSOrganizationsAsyncClientBuilder.standard();
    }

    AWSOrganizationsAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AcceptHandshakeResult> acceptHandshakeAsync(AcceptHandshakeRequest request) {
        return this.acceptHandshakeAsync(request, null);
    }

    @Override
    public Future<AcceptHandshakeResult> acceptHandshakeAsync(AcceptHandshakeRequest request, final AsyncHandler<AcceptHandshakeRequest, AcceptHandshakeResult> asyncHandler) {
        final AcceptHandshakeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AcceptHandshakeResult>(){

            @Override
            public AcceptHandshakeResult call() throws Exception {
                AcceptHandshakeResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeAcceptHandshake(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AttachPolicyResult> attachPolicyAsync(AttachPolicyRequest request) {
        return this.attachPolicyAsync(request, null);
    }

    @Override
    public Future<AttachPolicyResult> attachPolicyAsync(AttachPolicyRequest request, final AsyncHandler<AttachPolicyRequest, AttachPolicyResult> asyncHandler) {
        final AttachPolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AttachPolicyResult>(){

            @Override
            public AttachPolicyResult call() throws Exception {
                AttachPolicyResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeAttachPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelHandshakeResult> cancelHandshakeAsync(CancelHandshakeRequest request) {
        return this.cancelHandshakeAsync(request, null);
    }

    @Override
    public Future<CancelHandshakeResult> cancelHandshakeAsync(CancelHandshakeRequest request, final AsyncHandler<CancelHandshakeRequest, CancelHandshakeResult> asyncHandler) {
        final CancelHandshakeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelHandshakeResult>(){

            @Override
            public CancelHandshakeResult call() throws Exception {
                CancelHandshakeResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeCancelHandshake(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAccountResult> createAccountAsync(CreateAccountRequest request) {
        return this.createAccountAsync(request, null);
    }

    @Override
    public Future<CreateAccountResult> createAccountAsync(CreateAccountRequest request, final AsyncHandler<CreateAccountRequest, CreateAccountResult> asyncHandler) {
        final CreateAccountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAccountResult>(){

            @Override
            public CreateAccountResult call() throws Exception {
                CreateAccountResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeCreateAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateOrganizationResult> createOrganizationAsync(CreateOrganizationRequest request) {
        return this.createOrganizationAsync(request, null);
    }

    @Override
    public Future<CreateOrganizationResult> createOrganizationAsync(CreateOrganizationRequest request, final AsyncHandler<CreateOrganizationRequest, CreateOrganizationResult> asyncHandler) {
        final CreateOrganizationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateOrganizationResult>(){

            @Override
            public CreateOrganizationResult call() throws Exception {
                CreateOrganizationResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeCreateOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateOrganizationalUnitResult> createOrganizationalUnitAsync(CreateOrganizationalUnitRequest request) {
        return this.createOrganizationalUnitAsync(request, null);
    }

    @Override
    public Future<CreateOrganizationalUnitResult> createOrganizationalUnitAsync(CreateOrganizationalUnitRequest request, final AsyncHandler<CreateOrganizationalUnitRequest, CreateOrganizationalUnitResult> asyncHandler) {
        final CreateOrganizationalUnitRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateOrganizationalUnitResult>(){

            @Override
            public CreateOrganizationalUnitResult call() throws Exception {
                CreateOrganizationalUnitResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeCreateOrganizationalUnit(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreatePolicyResult> createPolicyAsync(CreatePolicyRequest request) {
        return this.createPolicyAsync(request, null);
    }

    @Override
    public Future<CreatePolicyResult> createPolicyAsync(CreatePolicyRequest request, final AsyncHandler<CreatePolicyRequest, CreatePolicyResult> asyncHandler) {
        final CreatePolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreatePolicyResult>(){

            @Override
            public CreatePolicyResult call() throws Exception {
                CreatePolicyResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeCreatePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeclineHandshakeResult> declineHandshakeAsync(DeclineHandshakeRequest request) {
        return this.declineHandshakeAsync(request, null);
    }

    @Override
    public Future<DeclineHandshakeResult> declineHandshakeAsync(DeclineHandshakeRequest request, final AsyncHandler<DeclineHandshakeRequest, DeclineHandshakeResult> asyncHandler) {
        final DeclineHandshakeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeclineHandshakeResult>(){

            @Override
            public DeclineHandshakeResult call() throws Exception {
                DeclineHandshakeResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDeclineHandshake(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteOrganizationResult> deleteOrganizationAsync(DeleteOrganizationRequest request) {
        return this.deleteOrganizationAsync(request, null);
    }

    @Override
    public Future<DeleteOrganizationResult> deleteOrganizationAsync(DeleteOrganizationRequest request, final AsyncHandler<DeleteOrganizationRequest, DeleteOrganizationResult> asyncHandler) {
        final DeleteOrganizationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteOrganizationResult>(){

            @Override
            public DeleteOrganizationResult call() throws Exception {
                DeleteOrganizationResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDeleteOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteOrganizationalUnitResult> deleteOrganizationalUnitAsync(DeleteOrganizationalUnitRequest request) {
        return this.deleteOrganizationalUnitAsync(request, null);
    }

    @Override
    public Future<DeleteOrganizationalUnitResult> deleteOrganizationalUnitAsync(DeleteOrganizationalUnitRequest request, final AsyncHandler<DeleteOrganizationalUnitRequest, DeleteOrganizationalUnitResult> asyncHandler) {
        final DeleteOrganizationalUnitRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteOrganizationalUnitResult>(){

            @Override
            public DeleteOrganizationalUnitResult call() throws Exception {
                DeleteOrganizationalUnitResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDeleteOrganizationalUnit(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(DeletePolicyRequest request) {
        return this.deletePolicyAsync(request, null);
    }

    @Override
    public Future<DeletePolicyResult> deletePolicyAsync(DeletePolicyRequest request, final AsyncHandler<DeletePolicyRequest, DeletePolicyResult> asyncHandler) {
        final DeletePolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeletePolicyResult>(){

            @Override
            public DeletePolicyResult call() throws Exception {
                DeletePolicyResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDeletePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeAccountResult> describeAccountAsync(DescribeAccountRequest request) {
        return this.describeAccountAsync(request, null);
    }

    @Override
    public Future<DescribeAccountResult> describeAccountAsync(DescribeAccountRequest request, final AsyncHandler<DescribeAccountRequest, DescribeAccountResult> asyncHandler) {
        final DescribeAccountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeAccountResult>(){

            @Override
            public DescribeAccountResult call() throws Exception {
                DescribeAccountResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDescribeAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeCreateAccountStatusResult> describeCreateAccountStatusAsync(DescribeCreateAccountStatusRequest request) {
        return this.describeCreateAccountStatusAsync(request, null);
    }

    @Override
    public Future<DescribeCreateAccountStatusResult> describeCreateAccountStatusAsync(DescribeCreateAccountStatusRequest request, final AsyncHandler<DescribeCreateAccountStatusRequest, DescribeCreateAccountStatusResult> asyncHandler) {
        final DescribeCreateAccountStatusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeCreateAccountStatusResult>(){

            @Override
            public DescribeCreateAccountStatusResult call() throws Exception {
                DescribeCreateAccountStatusResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDescribeCreateAccountStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHandshakeResult> describeHandshakeAsync(DescribeHandshakeRequest request) {
        return this.describeHandshakeAsync(request, null);
    }

    @Override
    public Future<DescribeHandshakeResult> describeHandshakeAsync(DescribeHandshakeRequest request, final AsyncHandler<DescribeHandshakeRequest, DescribeHandshakeResult> asyncHandler) {
        final DescribeHandshakeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeHandshakeResult>(){

            @Override
            public DescribeHandshakeResult call() throws Exception {
                DescribeHandshakeResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDescribeHandshake(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrganizationResult> describeOrganizationAsync(DescribeOrganizationRequest request) {
        return this.describeOrganizationAsync(request, null);
    }

    @Override
    public Future<DescribeOrganizationResult> describeOrganizationAsync(DescribeOrganizationRequest request, final AsyncHandler<DescribeOrganizationRequest, DescribeOrganizationResult> asyncHandler) {
        final DescribeOrganizationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOrganizationResult>(){

            @Override
            public DescribeOrganizationResult call() throws Exception {
                DescribeOrganizationResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDescribeOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeOrganizationalUnitResult> describeOrganizationalUnitAsync(DescribeOrganizationalUnitRequest request) {
        return this.describeOrganizationalUnitAsync(request, null);
    }

    @Override
    public Future<DescribeOrganizationalUnitResult> describeOrganizationalUnitAsync(DescribeOrganizationalUnitRequest request, final AsyncHandler<DescribeOrganizationalUnitRequest, DescribeOrganizationalUnitResult> asyncHandler) {
        final DescribeOrganizationalUnitRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeOrganizationalUnitResult>(){

            @Override
            public DescribeOrganizationalUnitResult call() throws Exception {
                DescribeOrganizationalUnitResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDescribeOrganizationalUnit(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribePolicyResult> describePolicyAsync(DescribePolicyRequest request) {
        return this.describePolicyAsync(request, null);
    }

    @Override
    public Future<DescribePolicyResult> describePolicyAsync(DescribePolicyRequest request, final AsyncHandler<DescribePolicyRequest, DescribePolicyResult> asyncHandler) {
        final DescribePolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribePolicyResult>(){

            @Override
            public DescribePolicyResult call() throws Exception {
                DescribePolicyResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDescribePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DetachPolicyResult> detachPolicyAsync(DetachPolicyRequest request) {
        return this.detachPolicyAsync(request, null);
    }

    @Override
    public Future<DetachPolicyResult> detachPolicyAsync(DetachPolicyRequest request, final AsyncHandler<DetachPolicyRequest, DetachPolicyResult> asyncHandler) {
        final DetachPolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DetachPolicyResult>(){

            @Override
            public DetachPolicyResult call() throws Exception {
                DetachPolicyResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDetachPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisablePolicyTypeResult> disablePolicyTypeAsync(DisablePolicyTypeRequest request) {
        return this.disablePolicyTypeAsync(request, null);
    }

    @Override
    public Future<DisablePolicyTypeResult> disablePolicyTypeAsync(DisablePolicyTypeRequest request, final AsyncHandler<DisablePolicyTypeRequest, DisablePolicyTypeResult> asyncHandler) {
        final DisablePolicyTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisablePolicyTypeResult>(){

            @Override
            public DisablePolicyTypeResult call() throws Exception {
                DisablePolicyTypeResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeDisablePolicyType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableAllFeaturesResult> enableAllFeaturesAsync(EnableAllFeaturesRequest request) {
        return this.enableAllFeaturesAsync(request, null);
    }

    @Override
    public Future<EnableAllFeaturesResult> enableAllFeaturesAsync(EnableAllFeaturesRequest request, final AsyncHandler<EnableAllFeaturesRequest, EnableAllFeaturesResult> asyncHandler) {
        final EnableAllFeaturesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableAllFeaturesResult>(){

            @Override
            public EnableAllFeaturesResult call() throws Exception {
                EnableAllFeaturesResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeEnableAllFeatures(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnablePolicyTypeResult> enablePolicyTypeAsync(EnablePolicyTypeRequest request) {
        return this.enablePolicyTypeAsync(request, null);
    }

    @Override
    public Future<EnablePolicyTypeResult> enablePolicyTypeAsync(EnablePolicyTypeRequest request, final AsyncHandler<EnablePolicyTypeRequest, EnablePolicyTypeResult> asyncHandler) {
        final EnablePolicyTypeRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnablePolicyTypeResult>(){

            @Override
            public EnablePolicyTypeResult call() throws Exception {
                EnablePolicyTypeResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeEnablePolicyType(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InviteAccountToOrganizationResult> inviteAccountToOrganizationAsync(InviteAccountToOrganizationRequest request) {
        return this.inviteAccountToOrganizationAsync(request, null);
    }

    @Override
    public Future<InviteAccountToOrganizationResult> inviteAccountToOrganizationAsync(InviteAccountToOrganizationRequest request, final AsyncHandler<InviteAccountToOrganizationRequest, InviteAccountToOrganizationResult> asyncHandler) {
        final InviteAccountToOrganizationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<InviteAccountToOrganizationResult>(){

            @Override
            public InviteAccountToOrganizationResult call() throws Exception {
                InviteAccountToOrganizationResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeInviteAccountToOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<LeaveOrganizationResult> leaveOrganizationAsync(LeaveOrganizationRequest request) {
        return this.leaveOrganizationAsync(request, null);
    }

    @Override
    public Future<LeaveOrganizationResult> leaveOrganizationAsync(LeaveOrganizationRequest request, final AsyncHandler<LeaveOrganizationRequest, LeaveOrganizationResult> asyncHandler) {
        final LeaveOrganizationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<LeaveOrganizationResult>(){

            @Override
            public LeaveOrganizationResult call() throws Exception {
                LeaveOrganizationResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeLeaveOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccountsResult> listAccountsAsync(ListAccountsRequest request) {
        return this.listAccountsAsync(request, null);
    }

    @Override
    public Future<ListAccountsResult> listAccountsAsync(ListAccountsRequest request, final AsyncHandler<ListAccountsRequest, ListAccountsResult> asyncHandler) {
        final ListAccountsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccountsResult>(){

            @Override
            public ListAccountsResult call() throws Exception {
                ListAccountsResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListAccounts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAccountsForParentResult> listAccountsForParentAsync(ListAccountsForParentRequest request) {
        return this.listAccountsForParentAsync(request, null);
    }

    @Override
    public Future<ListAccountsForParentResult> listAccountsForParentAsync(ListAccountsForParentRequest request, final AsyncHandler<ListAccountsForParentRequest, ListAccountsForParentResult> asyncHandler) {
        final ListAccountsForParentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAccountsForParentResult>(){

            @Override
            public ListAccountsForParentResult call() throws Exception {
                ListAccountsForParentResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListAccountsForParent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListChildrenResult> listChildrenAsync(ListChildrenRequest request) {
        return this.listChildrenAsync(request, null);
    }

    @Override
    public Future<ListChildrenResult> listChildrenAsync(ListChildrenRequest request, final AsyncHandler<ListChildrenRequest, ListChildrenResult> asyncHandler) {
        final ListChildrenRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListChildrenResult>(){

            @Override
            public ListChildrenResult call() throws Exception {
                ListChildrenResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListChildren(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListCreateAccountStatusResult> listCreateAccountStatusAsync(ListCreateAccountStatusRequest request) {
        return this.listCreateAccountStatusAsync(request, null);
    }

    @Override
    public Future<ListCreateAccountStatusResult> listCreateAccountStatusAsync(ListCreateAccountStatusRequest request, final AsyncHandler<ListCreateAccountStatusRequest, ListCreateAccountStatusResult> asyncHandler) {
        final ListCreateAccountStatusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListCreateAccountStatusResult>(){

            @Override
            public ListCreateAccountStatusResult call() throws Exception {
                ListCreateAccountStatusResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListCreateAccountStatus(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHandshakesForAccountResult> listHandshakesForAccountAsync(ListHandshakesForAccountRequest request) {
        return this.listHandshakesForAccountAsync(request, null);
    }

    @Override
    public Future<ListHandshakesForAccountResult> listHandshakesForAccountAsync(ListHandshakesForAccountRequest request, final AsyncHandler<ListHandshakesForAccountRequest, ListHandshakesForAccountResult> asyncHandler) {
        final ListHandshakesForAccountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListHandshakesForAccountResult>(){

            @Override
            public ListHandshakesForAccountResult call() throws Exception {
                ListHandshakesForAccountResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListHandshakesForAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHandshakesForOrganizationResult> listHandshakesForOrganizationAsync(ListHandshakesForOrganizationRequest request) {
        return this.listHandshakesForOrganizationAsync(request, null);
    }

    @Override
    public Future<ListHandshakesForOrganizationResult> listHandshakesForOrganizationAsync(ListHandshakesForOrganizationRequest request, final AsyncHandler<ListHandshakesForOrganizationRequest, ListHandshakesForOrganizationResult> asyncHandler) {
        final ListHandshakesForOrganizationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListHandshakesForOrganizationResult>(){

            @Override
            public ListHandshakesForOrganizationResult call() throws Exception {
                ListHandshakesForOrganizationResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListHandshakesForOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListOrganizationalUnitsForParentResult> listOrganizationalUnitsForParentAsync(ListOrganizationalUnitsForParentRequest request) {
        return this.listOrganizationalUnitsForParentAsync(request, null);
    }

    @Override
    public Future<ListOrganizationalUnitsForParentResult> listOrganizationalUnitsForParentAsync(ListOrganizationalUnitsForParentRequest request, final AsyncHandler<ListOrganizationalUnitsForParentRequest, ListOrganizationalUnitsForParentResult> asyncHandler) {
        final ListOrganizationalUnitsForParentRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListOrganizationalUnitsForParentResult>(){

            @Override
            public ListOrganizationalUnitsForParentResult call() throws Exception {
                ListOrganizationalUnitsForParentResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListOrganizationalUnitsForParent(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListParentsResult> listParentsAsync(ListParentsRequest request) {
        return this.listParentsAsync(request, null);
    }

    @Override
    public Future<ListParentsResult> listParentsAsync(ListParentsRequest request, final AsyncHandler<ListParentsRequest, ListParentsResult> asyncHandler) {
        final ListParentsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListParentsResult>(){

            @Override
            public ListParentsResult call() throws Exception {
                ListParentsResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListParents(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(ListPoliciesRequest request) {
        return this.listPoliciesAsync(request, null);
    }

    @Override
    public Future<ListPoliciesResult> listPoliciesAsync(ListPoliciesRequest request, final AsyncHandler<ListPoliciesRequest, ListPoliciesResult> asyncHandler) {
        final ListPoliciesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPoliciesResult>(){

            @Override
            public ListPoliciesResult call() throws Exception {
                ListPoliciesResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListPolicies(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPoliciesForTargetResult> listPoliciesForTargetAsync(ListPoliciesForTargetRequest request) {
        return this.listPoliciesForTargetAsync(request, null);
    }

    @Override
    public Future<ListPoliciesForTargetResult> listPoliciesForTargetAsync(ListPoliciesForTargetRequest request, final AsyncHandler<ListPoliciesForTargetRequest, ListPoliciesForTargetResult> asyncHandler) {
        final ListPoliciesForTargetRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListPoliciesForTargetResult>(){

            @Override
            public ListPoliciesForTargetResult call() throws Exception {
                ListPoliciesForTargetResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListPoliciesForTarget(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListRootsResult> listRootsAsync(ListRootsRequest request) {
        return this.listRootsAsync(request, null);
    }

    @Override
    public Future<ListRootsResult> listRootsAsync(ListRootsRequest request, final AsyncHandler<ListRootsRequest, ListRootsResult> asyncHandler) {
        final ListRootsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListRootsResult>(){

            @Override
            public ListRootsResult call() throws Exception {
                ListRootsResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListRoots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTargetsForPolicyResult> listTargetsForPolicyAsync(ListTargetsForPolicyRequest request) {
        return this.listTargetsForPolicyAsync(request, null);
    }

    @Override
    public Future<ListTargetsForPolicyResult> listTargetsForPolicyAsync(ListTargetsForPolicyRequest request, final AsyncHandler<ListTargetsForPolicyRequest, ListTargetsForPolicyResult> asyncHandler) {
        final ListTargetsForPolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTargetsForPolicyResult>(){

            @Override
            public ListTargetsForPolicyResult call() throws Exception {
                ListTargetsForPolicyResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeListTargetsForPolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<MoveAccountResult> moveAccountAsync(MoveAccountRequest request) {
        return this.moveAccountAsync(request, null);
    }

    @Override
    public Future<MoveAccountResult> moveAccountAsync(MoveAccountRequest request, final AsyncHandler<MoveAccountRequest, MoveAccountResult> asyncHandler) {
        final MoveAccountRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<MoveAccountResult>(){

            @Override
            public MoveAccountResult call() throws Exception {
                MoveAccountResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeMoveAccount(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveAccountFromOrganizationResult> removeAccountFromOrganizationAsync(RemoveAccountFromOrganizationRequest request) {
        return this.removeAccountFromOrganizationAsync(request, null);
    }

    @Override
    public Future<RemoveAccountFromOrganizationResult> removeAccountFromOrganizationAsync(RemoveAccountFromOrganizationRequest request, final AsyncHandler<RemoveAccountFromOrganizationRequest, RemoveAccountFromOrganizationResult> asyncHandler) {
        final RemoveAccountFromOrganizationRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveAccountFromOrganizationResult>(){

            @Override
            public RemoveAccountFromOrganizationResult call() throws Exception {
                RemoveAccountFromOrganizationResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeRemoveAccountFromOrganization(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateOrganizationalUnitResult> updateOrganizationalUnitAsync(UpdateOrganizationalUnitRequest request) {
        return this.updateOrganizationalUnitAsync(request, null);
    }

    @Override
    public Future<UpdateOrganizationalUnitResult> updateOrganizationalUnitAsync(UpdateOrganizationalUnitRequest request, final AsyncHandler<UpdateOrganizationalUnitRequest, UpdateOrganizationalUnitResult> asyncHandler) {
        final UpdateOrganizationalUnitRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateOrganizationalUnitResult>(){

            @Override
            public UpdateOrganizationalUnitResult call() throws Exception {
                UpdateOrganizationalUnitResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeUpdateOrganizationalUnit(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdatePolicyResult> updatePolicyAsync(UpdatePolicyRequest request) {
        return this.updatePolicyAsync(request, null);
    }

    @Override
    public Future<UpdatePolicyResult> updatePolicyAsync(UpdatePolicyRequest request, final AsyncHandler<UpdatePolicyRequest, UpdatePolicyResult> asyncHandler) {
        final UpdatePolicyRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdatePolicyResult>(){

            @Override
            public UpdatePolicyResult call() throws Exception {
                UpdatePolicyResult result = null;
                try {
                    result = AWSOrganizationsAsyncClient.this.executeUpdatePolicy(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

