/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.glue.model.Action;
import com.amazonaws.services.glue.model.Predicate;
import com.amazonaws.services.glue.model.TriggerType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateTriggerRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String type;
    private String schedule;
    private Predicate predicate;
    private List<Action> actions;
    private String description;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateTriggerRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    public CreateTriggerRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateTriggerRequest withType(TriggerType type) {
        this.type = type.toString();
        return this;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public CreateTriggerRequest withSchedule(String schedule) {
        this.setSchedule(schedule);
        return this;
    }

    public void setPredicate(Predicate predicate) {
        this.predicate = predicate;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public CreateTriggerRequest withPredicate(Predicate predicate) {
        this.setPredicate(predicate);
        return this;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void setActions(Collection<Action> actions) {
        if (actions == null) {
            this.actions = null;
            return;
        }
        this.actions = new ArrayList<Action>(actions);
    }

    public CreateTriggerRequest withActions(Action ... actions) {
        if (this.actions == null) {
            this.setActions(new ArrayList<Action>(actions.length));
        }
        for (Action ele : actions) {
            this.actions.add(ele);
        }
        return this;
    }

    public CreateTriggerRequest withActions(Collection<Action> actions) {
        this.setActions(actions);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateTriggerRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getSchedule() != null) {
            sb.append("Schedule: ").append(this.getSchedule()).append(",");
        }
        if (this.getPredicate() != null) {
            sb.append("Predicate: ").append(this.getPredicate()).append(",");
        }
        if (this.getActions() != null) {
            sb.append("Actions: ").append(this.getActions()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTriggerRequest)) {
            return false;
        }
        CreateTriggerRequest other = (CreateTriggerRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getSchedule() == null ^ this.getSchedule() == null) {
            return false;
        }
        if (other.getSchedule() != null && !other.getSchedule().equals(this.getSchedule())) {
            return false;
        }
        if (other.getPredicate() == null ^ this.getPredicate() == null) {
            return false;
        }
        if (other.getPredicate() != null && !other.getPredicate().equals(this.getPredicate())) {
            return false;
        }
        if (other.getActions() == null ^ this.getActions() == null) {
            return false;
        }
        if (other.getActions() != null && !other.getActions().equals(this.getActions())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        return other.getDescription() == null || other.getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getSchedule() == null ? 0 : this.getSchedule().hashCode());
        hashCode = 31 * hashCode + (this.getPredicate() == null ? 0 : this.getPredicate().hashCode());
        hashCode = 31 * hashCode + (this.getActions() == null ? 0 : this.getActions().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        return hashCode;
    }

    @Override
    public CreateTriggerRequest clone() {
        return (CreateTriggerRequest)super.clone();
    }
}

