/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.cognitoidp.model.AttributeType;
import com.amazonaws.services.cognitoidp.model.DeliveryMediumType;
import com.amazonaws.services.cognitoidp.model.MessageActionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AdminCreateUserRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String userPoolId;
    private String username;
    private List<AttributeType> userAttributes;
    private List<AttributeType> validationData;
    private String temporaryPassword;
    private Boolean forceAliasCreation;
    private String messageAction;
    private List<String> desiredDeliveryMediums;

    public void setUserPoolId(String userPoolId) {
        this.userPoolId = userPoolId;
    }

    public String getUserPoolId() {
        return this.userPoolId;
    }

    public AdminCreateUserRequest withUserPoolId(String userPoolId) {
        this.setUserPoolId(userPoolId);
        return this;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public AdminCreateUserRequest withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public List<AttributeType> getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(Collection<AttributeType> userAttributes) {
        if (userAttributes == null) {
            this.userAttributes = null;
            return;
        }
        this.userAttributes = new ArrayList<AttributeType>(userAttributes);
    }

    public AdminCreateUserRequest withUserAttributes(AttributeType ... userAttributes) {
        if (this.userAttributes == null) {
            this.setUserAttributes(new ArrayList<AttributeType>(userAttributes.length));
        }
        for (AttributeType ele : userAttributes) {
            this.userAttributes.add(ele);
        }
        return this;
    }

    public AdminCreateUserRequest withUserAttributes(Collection<AttributeType> userAttributes) {
        this.setUserAttributes(userAttributes);
        return this;
    }

    public List<AttributeType> getValidationData() {
        return this.validationData;
    }

    public void setValidationData(Collection<AttributeType> validationData) {
        if (validationData == null) {
            this.validationData = null;
            return;
        }
        this.validationData = new ArrayList<AttributeType>(validationData);
    }

    public AdminCreateUserRequest withValidationData(AttributeType ... validationData) {
        if (this.validationData == null) {
            this.setValidationData(new ArrayList<AttributeType>(validationData.length));
        }
        for (AttributeType ele : validationData) {
            this.validationData.add(ele);
        }
        return this;
    }

    public AdminCreateUserRequest withValidationData(Collection<AttributeType> validationData) {
        this.setValidationData(validationData);
        return this;
    }

    public void setTemporaryPassword(String temporaryPassword) {
        this.temporaryPassword = temporaryPassword;
    }

    public String getTemporaryPassword() {
        return this.temporaryPassword;
    }

    public AdminCreateUserRequest withTemporaryPassword(String temporaryPassword) {
        this.setTemporaryPassword(temporaryPassword);
        return this;
    }

    public void setForceAliasCreation(Boolean forceAliasCreation) {
        this.forceAliasCreation = forceAliasCreation;
    }

    public Boolean getForceAliasCreation() {
        return this.forceAliasCreation;
    }

    public AdminCreateUserRequest withForceAliasCreation(Boolean forceAliasCreation) {
        this.setForceAliasCreation(forceAliasCreation);
        return this;
    }

    public Boolean isForceAliasCreation() {
        return this.forceAliasCreation;
    }

    public void setMessageAction(String messageAction) {
        this.messageAction = messageAction;
    }

    @JsonProperty(value="messageAction")
    public String getMessageAction() {
        return this.messageAction;
    }

    public AdminCreateUserRequest withMessageAction(String messageAction) {
        this.setMessageAction(messageAction);
        return this;
    }

    @JsonIgnore
    public void setMessageAction(MessageActionType messageAction) {
        this.withMessageAction(messageAction);
    }

    public AdminCreateUserRequest withMessageAction(MessageActionType messageAction) {
        this.messageAction = messageAction.toString();
        return this;
    }

    public List<String> getDesiredDeliveryMediums() {
        return this.desiredDeliveryMediums;
    }

    public void setDesiredDeliveryMediums(Collection<String> desiredDeliveryMediums) {
        if (desiredDeliveryMediums == null) {
            this.desiredDeliveryMediums = null;
            return;
        }
        this.desiredDeliveryMediums = new ArrayList<String>(desiredDeliveryMediums);
    }

    public AdminCreateUserRequest withDesiredDeliveryMediums(String ... desiredDeliveryMediums) {
        if (this.desiredDeliveryMediums == null) {
            this.setDesiredDeliveryMediums(new ArrayList<String>(desiredDeliveryMediums.length));
        }
        for (String ele : desiredDeliveryMediums) {
            this.desiredDeliveryMediums.add(ele);
        }
        return this;
    }

    public AdminCreateUserRequest withDesiredDeliveryMediums(Collection<String> desiredDeliveryMediums) {
        this.setDesiredDeliveryMediums(desiredDeliveryMediums);
        return this;
    }

    public AdminCreateUserRequest withDesiredDeliveryMediums(DeliveryMediumType ... desiredDeliveryMediums) {
        ArrayList<String> desiredDeliveryMediumsCopy = new ArrayList<String>(desiredDeliveryMediums.length);
        for (DeliveryMediumType value : desiredDeliveryMediums) {
            desiredDeliveryMediumsCopy.add(value.toString());
        }
        if (this.getDesiredDeliveryMediums() == null) {
            this.setDesiredDeliveryMediums(desiredDeliveryMediumsCopy);
        } else {
            this.getDesiredDeliveryMediums().addAll(desiredDeliveryMediumsCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getUserPoolId() != null) {
            sb.append("UserPoolId: ").append(this.getUserPoolId()).append(",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername()).append(",");
        }
        if (this.getUserAttributes() != null) {
            sb.append("UserAttributes: ").append(this.getUserAttributes()).append(",");
        }
        if (this.getValidationData() != null) {
            sb.append("ValidationData: ").append(this.getValidationData()).append(",");
        }
        if (this.getTemporaryPassword() != null) {
            sb.append("TemporaryPassword: ").append(this.getTemporaryPassword()).append(",");
        }
        if (this.getForceAliasCreation() != null) {
            sb.append("ForceAliasCreation: ").append(this.getForceAliasCreation()).append(",");
        }
        if (this.getMessageAction() != null) {
            sb.append("MessageAction: ").append(this.getMessageAction()).append(",");
        }
        if (this.getDesiredDeliveryMediums() != null) {
            sb.append("DesiredDeliveryMediums: ").append(this.getDesiredDeliveryMediums());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdminCreateUserRequest)) {
            return false;
        }
        AdminCreateUserRequest other = (AdminCreateUserRequest)obj;
        if (other.getUserPoolId() == null ^ this.getUserPoolId() == null) {
            return false;
        }
        if (other.getUserPoolId() != null && !other.getUserPoolId().equals(this.getUserPoolId())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getUserAttributes() == null ^ this.getUserAttributes() == null) {
            return false;
        }
        if (other.getUserAttributes() != null && !other.getUserAttributes().equals(this.getUserAttributes())) {
            return false;
        }
        if (other.getValidationData() == null ^ this.getValidationData() == null) {
            return false;
        }
        if (other.getValidationData() != null && !other.getValidationData().equals(this.getValidationData())) {
            return false;
        }
        if (other.getTemporaryPassword() == null ^ this.getTemporaryPassword() == null) {
            return false;
        }
        if (other.getTemporaryPassword() != null && !other.getTemporaryPassword().equals(this.getTemporaryPassword())) {
            return false;
        }
        if (other.getForceAliasCreation() == null ^ this.getForceAliasCreation() == null) {
            return false;
        }
        if (other.getForceAliasCreation() != null && !other.getForceAliasCreation().equals(this.getForceAliasCreation())) {
            return false;
        }
        if (other.getMessageAction() == null ^ this.getMessageAction() == null) {
            return false;
        }
        if (other.getMessageAction() != null && !other.getMessageAction().equals(this.getMessageAction())) {
            return false;
        }
        if (other.getDesiredDeliveryMediums() == null ^ this.getDesiredDeliveryMediums() == null) {
            return false;
        }
        return other.getDesiredDeliveryMediums() == null || other.getDesiredDeliveryMediums().equals(this.getDesiredDeliveryMediums());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getUserPoolId() == null ? 0 : this.getUserPoolId().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getUserAttributes() == null ? 0 : this.getUserAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getValidationData() == null ? 0 : this.getValidationData().hashCode());
        hashCode = 31 * hashCode + (this.getTemporaryPassword() == null ? 0 : this.getTemporaryPassword().hashCode());
        hashCode = 31 * hashCode + (this.getForceAliasCreation() == null ? 0 : this.getForceAliasCreation().hashCode());
        hashCode = 31 * hashCode + (this.getMessageAction() == null ? 0 : this.getMessageAction().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredDeliveryMediums() == null ? 0 : this.getDesiredDeliveryMediums().hashCode());
        return hashCode;
    }

    @Override
    public AdminCreateUserRequest clone() {
        return (AdminCreateUserRequest)super.clone();
    }
}

