/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.applicationdiscovery.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.applicationdiscovery.model.ExportDataFormat;
import com.amazonaws.services.applicationdiscovery.model.ExportFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class StartExportTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> exportDataFormat;
    private List<ExportFilter> filters;
    private Date startTime;
    private Date endTime;

    public List<String> getExportDataFormat() {
        return this.exportDataFormat;
    }

    public void setExportDataFormat(Collection<String> exportDataFormat) {
        if (exportDataFormat == null) {
            this.exportDataFormat = null;
            return;
        }
        this.exportDataFormat = new ArrayList<String>(exportDataFormat);
    }

    public StartExportTaskRequest withExportDataFormat(String ... exportDataFormat) {
        if (this.exportDataFormat == null) {
            this.setExportDataFormat(new ArrayList<String>(exportDataFormat.length));
        }
        for (String ele : exportDataFormat) {
            this.exportDataFormat.add(ele);
        }
        return this;
    }

    public StartExportTaskRequest withExportDataFormat(Collection<String> exportDataFormat) {
        this.setExportDataFormat(exportDataFormat);
        return this;
    }

    public StartExportTaskRequest withExportDataFormat(ExportDataFormat ... exportDataFormat) {
        ArrayList<String> exportDataFormatCopy = new ArrayList<String>(exportDataFormat.length);
        for (ExportDataFormat value : exportDataFormat) {
            exportDataFormatCopy.add(value.toString());
        }
        if (this.getExportDataFormat() == null) {
            this.setExportDataFormat(exportDataFormatCopy);
        } else {
            this.getExportDataFormat().addAll(exportDataFormatCopy);
        }
        return this;
    }

    public List<ExportFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<ExportFilter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<ExportFilter>(filters);
    }

    public StartExportTaskRequest withFilters(ExportFilter ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<ExportFilter>(filters.length));
        }
        for (ExportFilter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public StartExportTaskRequest withFilters(Collection<ExportFilter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public StartExportTaskRequest withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public StartExportTaskRequest withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getExportDataFormat() != null) {
            sb.append("ExportDataFormat: ").append(this.getExportDataFormat()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest)obj;
        if (other.getExportDataFormat() == null ^ this.getExportDataFormat() == null) {
            return false;
        }
        if (other.getExportDataFormat() != null && !other.getExportDataFormat().equals(this.getExportDataFormat())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        return other.getEndTime() == null || other.getEndTime().equals(this.getEndTime());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getExportDataFormat() == null ? 0 : this.getExportDataFormat().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        return hashCode;
    }

    @Override
    public StartExportTaskRequest clone() {
        return (StartExportTaskRequest)super.clone();
    }
}

