/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.xray.model.TraceUser;
import java.util.List;

@SdkInternalApi
public class TraceUserMarshaller {
    private static final MarshallingInfo<String> USERNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UserName").build();
    private static final MarshallingInfo<List> SERVICEIDS_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ServiceIds").build();
    private static final TraceUserMarshaller instance = new TraceUserMarshaller();

    public static TraceUserMarshaller getInstance() {
        return instance;
    }

    public void marshall(TraceUser traceUser, ProtocolMarshaller protocolMarshaller) {
        if (traceUser == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(traceUser.getUserName(), USERNAME_BINDING);
            protocolMarshaller.marshall(traceUser.getServiceIds(), SERVICEIDS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

