/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.servermigration.model.LicenseType;
import com.amazonaws.services.servermigration.model.ReplicationJobState;
import com.amazonaws.services.servermigration.model.ReplicationRun;
import com.amazonaws.services.servermigration.model.ServerType;
import com.amazonaws.services.servermigration.model.VmServer;
import com.amazonaws.services.servermigration.model.transform.ReplicationJobMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ReplicationJob
implements Serializable,
Cloneable,
StructuredPojo {
    private String replicationJobId;
    private String serverId;
    private String serverType;
    private VmServer vmServer;
    private Date seedReplicationTime;
    private Integer frequency;
    private Date nextReplicationRunStartTime;
    private String licenseType;
    private String roleName;
    private String latestAmiId;
    private String state;
    private String statusMessage;
    private String description;
    private List<ReplicationRun> replicationRunList;

    public void setReplicationJobId(String replicationJobId) {
        this.replicationJobId = replicationJobId;
    }

    public String getReplicationJobId() {
        return this.replicationJobId;
    }

    public ReplicationJob withReplicationJobId(String replicationJobId) {
        this.setReplicationJobId(replicationJobId);
        return this;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerId() {
        return this.serverId;
    }

    public ReplicationJob withServerId(String serverId) {
        this.setServerId(serverId);
        return this;
    }

    public void setServerType(String serverType) {
        this.serverType = serverType;
    }

    @JsonProperty(value="serverType")
    public String getServerType() {
        return this.serverType;
    }

    public ReplicationJob withServerType(String serverType) {
        this.setServerType(serverType);
        return this;
    }

    @JsonIgnore
    public void setServerType(ServerType serverType) {
        this.withServerType(serverType);
    }

    public ReplicationJob withServerType(ServerType serverType) {
        this.serverType = serverType.toString();
        return this;
    }

    public void setVmServer(VmServer vmServer) {
        this.vmServer = vmServer;
    }

    public VmServer getVmServer() {
        return this.vmServer;
    }

    public ReplicationJob withVmServer(VmServer vmServer) {
        this.setVmServer(vmServer);
        return this;
    }

    public void setSeedReplicationTime(Date seedReplicationTime) {
        this.seedReplicationTime = seedReplicationTime;
    }

    public Date getSeedReplicationTime() {
        return this.seedReplicationTime;
    }

    public ReplicationJob withSeedReplicationTime(Date seedReplicationTime) {
        this.setSeedReplicationTime(seedReplicationTime);
        return this;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public Integer getFrequency() {
        return this.frequency;
    }

    public ReplicationJob withFrequency(Integer frequency) {
        this.setFrequency(frequency);
        return this;
    }

    public void setNextReplicationRunStartTime(Date nextReplicationRunStartTime) {
        this.nextReplicationRunStartTime = nextReplicationRunStartTime;
    }

    public Date getNextReplicationRunStartTime() {
        return this.nextReplicationRunStartTime;
    }

    public ReplicationJob withNextReplicationRunStartTime(Date nextReplicationRunStartTime) {
        this.setNextReplicationRunStartTime(nextReplicationRunStartTime);
        return this;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    @JsonProperty(value="licenseType")
    public String getLicenseType() {
        return this.licenseType;
    }

    public ReplicationJob withLicenseType(String licenseType) {
        this.setLicenseType(licenseType);
        return this;
    }

    @JsonIgnore
    public void setLicenseType(LicenseType licenseType) {
        this.withLicenseType(licenseType);
    }

    public ReplicationJob withLicenseType(LicenseType licenseType) {
        this.licenseType = licenseType.toString();
        return this;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    public ReplicationJob withRoleName(String roleName) {
        this.setRoleName(roleName);
        return this;
    }

    public void setLatestAmiId(String latestAmiId) {
        this.latestAmiId = latestAmiId;
    }

    public String getLatestAmiId() {
        return this.latestAmiId;
    }

    public ReplicationJob withLatestAmiId(String latestAmiId) {
        this.setLatestAmiId(latestAmiId);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public ReplicationJob withState(String state) {
        this.setState(state);
        return this;
    }

    @JsonIgnore
    public void setState(ReplicationJobState state) {
        this.withState(state);
    }

    public ReplicationJob withState(ReplicationJobState state) {
        this.state = state.toString();
        return this;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public ReplicationJob withStatusMessage(String statusMessage) {
        this.setStatusMessage(statusMessage);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ReplicationJob withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<ReplicationRun> getReplicationRunList() {
        return this.replicationRunList;
    }

    public void setReplicationRunList(Collection<ReplicationRun> replicationRunList) {
        if (replicationRunList == null) {
            this.replicationRunList = null;
            return;
        }
        this.replicationRunList = new ArrayList<ReplicationRun>(replicationRunList);
    }

    public ReplicationJob withReplicationRunList(ReplicationRun ... replicationRunList) {
        if (this.replicationRunList == null) {
            this.setReplicationRunList(new ArrayList<ReplicationRun>(replicationRunList.length));
        }
        for (ReplicationRun ele : replicationRunList) {
            this.replicationRunList.add(ele);
        }
        return this;
    }

    public ReplicationJob withReplicationRunList(Collection<ReplicationRun> replicationRunList) {
        this.setReplicationRunList(replicationRunList);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReplicationJobId() != null) {
            sb.append("ReplicationJobId: ").append(this.getReplicationJobId()).append(",");
        }
        if (this.getServerId() != null) {
            sb.append("ServerId: ").append(this.getServerId()).append(",");
        }
        if (this.getServerType() != null) {
            sb.append("ServerType: ").append(this.getServerType()).append(",");
        }
        if (this.getVmServer() != null) {
            sb.append("VmServer: ").append(this.getVmServer()).append(",");
        }
        if (this.getSeedReplicationTime() != null) {
            sb.append("SeedReplicationTime: ").append(this.getSeedReplicationTime()).append(",");
        }
        if (this.getFrequency() != null) {
            sb.append("Frequency: ").append(this.getFrequency()).append(",");
        }
        if (this.getNextReplicationRunStartTime() != null) {
            sb.append("NextReplicationRunStartTime: ").append(this.getNextReplicationRunStartTime()).append(",");
        }
        if (this.getLicenseType() != null) {
            sb.append("LicenseType: ").append(this.getLicenseType()).append(",");
        }
        if (this.getRoleName() != null) {
            sb.append("RoleName: ").append(this.getRoleName()).append(",");
        }
        if (this.getLatestAmiId() != null) {
            sb.append("LatestAmiId: ").append(this.getLatestAmiId()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getStatusMessage() != null) {
            sb.append("StatusMessage: ").append(this.getStatusMessage()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getReplicationRunList() != null) {
            sb.append("ReplicationRunList: ").append(this.getReplicationRunList());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationJob)) {
            return false;
        }
        ReplicationJob other = (ReplicationJob)obj;
        if (other.getReplicationJobId() == null ^ this.getReplicationJobId() == null) {
            return false;
        }
        if (other.getReplicationJobId() != null && !other.getReplicationJobId().equals(this.getReplicationJobId())) {
            return false;
        }
        if (other.getServerId() == null ^ this.getServerId() == null) {
            return false;
        }
        if (other.getServerId() != null && !other.getServerId().equals(this.getServerId())) {
            return false;
        }
        if (other.getServerType() == null ^ this.getServerType() == null) {
            return false;
        }
        if (other.getServerType() != null && !other.getServerType().equals(this.getServerType())) {
            return false;
        }
        if (other.getVmServer() == null ^ this.getVmServer() == null) {
            return false;
        }
        if (other.getVmServer() != null && !other.getVmServer().equals(this.getVmServer())) {
            return false;
        }
        if (other.getSeedReplicationTime() == null ^ this.getSeedReplicationTime() == null) {
            return false;
        }
        if (other.getSeedReplicationTime() != null && !other.getSeedReplicationTime().equals(this.getSeedReplicationTime())) {
            return false;
        }
        if (other.getFrequency() == null ^ this.getFrequency() == null) {
            return false;
        }
        if (other.getFrequency() != null && !other.getFrequency().equals(this.getFrequency())) {
            return false;
        }
        if (other.getNextReplicationRunStartTime() == null ^ this.getNextReplicationRunStartTime() == null) {
            return false;
        }
        if (other.getNextReplicationRunStartTime() != null && !other.getNextReplicationRunStartTime().equals(this.getNextReplicationRunStartTime())) {
            return false;
        }
        if (other.getLicenseType() == null ^ this.getLicenseType() == null) {
            return false;
        }
        if (other.getLicenseType() != null && !other.getLicenseType().equals(this.getLicenseType())) {
            return false;
        }
        if (other.getRoleName() == null ^ this.getRoleName() == null) {
            return false;
        }
        if (other.getRoleName() != null && !other.getRoleName().equals(this.getRoleName())) {
            return false;
        }
        if (other.getLatestAmiId() == null ^ this.getLatestAmiId() == null) {
            return false;
        }
        if (other.getLatestAmiId() != null && !other.getLatestAmiId().equals(this.getLatestAmiId())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null) {
            return false;
        }
        if (other.getStatusMessage() != null && !other.getStatusMessage().equals(this.getStatusMessage())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getReplicationRunList() == null ^ this.getReplicationRunList() == null) {
            return false;
        }
        return other.getReplicationRunList() == null || other.getReplicationRunList().equals(this.getReplicationRunList());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReplicationJobId() == null ? 0 : this.getReplicationJobId().hashCode());
        hashCode = 31 * hashCode + (this.getServerId() == null ? 0 : this.getServerId().hashCode());
        hashCode = 31 * hashCode + (this.getServerType() == null ? 0 : this.getServerType().hashCode());
        hashCode = 31 * hashCode + (this.getVmServer() == null ? 0 : this.getVmServer().hashCode());
        hashCode = 31 * hashCode + (this.getSeedReplicationTime() == null ? 0 : this.getSeedReplicationTime().hashCode());
        hashCode = 31 * hashCode + (this.getFrequency() == null ? 0 : this.getFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getNextReplicationRunStartTime() == null ? 0 : this.getNextReplicationRunStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseType() == null ? 0 : this.getLicenseType().hashCode());
        hashCode = 31 * hashCode + (this.getRoleName() == null ? 0 : this.getRoleName().hashCode());
        hashCode = 31 * hashCode + (this.getLatestAmiId() == null ? 0 : this.getLatestAmiId().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getStatusMessage() == null ? 0 : this.getStatusMessage().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getReplicationRunList() == null ? 0 : this.getReplicationRunList().hashCode());
        return hashCode;
    }

    public ReplicationJob clone() {
        try {
            return (ReplicationJob)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationJobMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

