/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.pinpoint.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.pinpoint.model.BaiduChannelRequest;

@SdkInternalApi
public class BaiduChannelRequestMarshaller {
    private static final MarshallingInfo<String> APIKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ApiKey").build();
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<String> SECRETKEY_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecretKey").build();
    private static final BaiduChannelRequestMarshaller instance = new BaiduChannelRequestMarshaller();

    public static BaiduChannelRequestMarshaller getInstance() {
        return instance;
    }

    public void marshall(BaiduChannelRequest baiduChannelRequest, ProtocolMarshaller protocolMarshaller) {
        if (baiduChannelRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(baiduChannelRequest.getApiKey(), APIKEY_BINDING);
            protocolMarshaller.marshall(baiduChannelRequest.getEnabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(baiduChannelRequest.getSecretKey(), SECRETKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

