/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector.model.InspectorEvent;
import com.amazonaws.services.inspector.model.transform.EventSubscriptionMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;

public class EventSubscription
implements Serializable,
Cloneable,
StructuredPojo {
    private String event;
    private Date subscribedAt;

    public void setEvent(String event) {
        this.event = event;
    }

    @JsonProperty(value="event")
    public String getEvent() {
        return this.event;
    }

    public EventSubscription withEvent(String event) {
        this.setEvent(event);
        return this;
    }

    @JsonIgnore
    public void setEvent(InspectorEvent event) {
        this.withEvent(event);
    }

    public EventSubscription withEvent(InspectorEvent event) {
        this.event = event.toString();
        return this;
    }

    public void setSubscribedAt(Date subscribedAt) {
        this.subscribedAt = subscribedAt;
    }

    public Date getSubscribedAt() {
        return this.subscribedAt;
    }

    public EventSubscription withSubscribedAt(Date subscribedAt) {
        this.setSubscribedAt(subscribedAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEvent() != null) {
            sb.append("Event: ").append(this.getEvent()).append(",");
        }
        if (this.getSubscribedAt() != null) {
            sb.append("SubscribedAt: ").append(this.getSubscribedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventSubscription)) {
            return false;
        }
        EventSubscription other = (EventSubscription)obj;
        if (other.getEvent() == null ^ this.getEvent() == null) {
            return false;
        }
        if (other.getEvent() != null && !other.getEvent().equals(this.getEvent())) {
            return false;
        }
        if (other.getSubscribedAt() == null ^ this.getSubscribedAt() == null) {
            return false;
        }
        return other.getSubscribedAt() == null || other.getSubscribedAt().equals(this.getSubscribedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEvent() == null ? 0 : this.getEvent().hashCode());
        hashCode = 31 * hashCode + (this.getSubscribedAt() == null ? 0 : this.getSubscribedAt().hashCode());
        return hashCode;
    }

    public EventSubscription clone() {
        try {
            return (EventSubscription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventSubscriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

