/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.TransportProtocol;
import com.amazonaws.services.ecs.model.transform.NetworkBindingMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;

public class NetworkBinding
implements Serializable,
Cloneable,
StructuredPojo {
    private String bindIP;
    private Integer containerPort;
    private Integer hostPort;
    private String protocol;

    public void setBindIP(String bindIP) {
        this.bindIP = bindIP;
    }

    public String getBindIP() {
        return this.bindIP;
    }

    public NetworkBinding withBindIP(String bindIP) {
        this.setBindIP(bindIP);
        return this;
    }

    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    public Integer getContainerPort() {
        return this.containerPort;
    }

    public NetworkBinding withContainerPort(Integer containerPort) {
        this.setContainerPort(containerPort);
        return this;
    }

    public void setHostPort(Integer hostPort) {
        this.hostPort = hostPort;
    }

    public Integer getHostPort() {
        return this.hostPort;
    }

    public NetworkBinding withHostPort(Integer hostPort) {
        this.setHostPort(hostPort);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @JsonProperty(value="protocol")
    public String getProtocol() {
        return this.protocol;
    }

    public NetworkBinding withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    @JsonIgnore
    public void setProtocol(TransportProtocol protocol) {
        this.withProtocol(protocol);
    }

    public NetworkBinding withProtocol(TransportProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBindIP() != null) {
            sb.append("BindIP: ").append(this.getBindIP()).append(",");
        }
        if (this.getContainerPort() != null) {
            sb.append("ContainerPort: ").append(this.getContainerPort()).append(",");
        }
        if (this.getHostPort() != null) {
            sb.append("HostPort: ").append(this.getHostPort()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkBinding)) {
            return false;
        }
        NetworkBinding other = (NetworkBinding)obj;
        if (other.getBindIP() == null ^ this.getBindIP() == null) {
            return false;
        }
        if (other.getBindIP() != null && !other.getBindIP().equals(this.getBindIP())) {
            return false;
        }
        if (other.getContainerPort() == null ^ this.getContainerPort() == null) {
            return false;
        }
        if (other.getContainerPort() != null && !other.getContainerPort().equals(this.getContainerPort())) {
            return false;
        }
        if (other.getHostPort() == null ^ this.getHostPort() == null) {
            return false;
        }
        if (other.getHostPort() != null && !other.getHostPort().equals(this.getHostPort())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        return other.getProtocol() == null || other.getProtocol().equals(this.getProtocol());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBindIP() == null ? 0 : this.getBindIP().hashCode());
        hashCode = 31 * hashCode + (this.getContainerPort() == null ? 0 : this.getContainerPort().hashCode());
        hashCode = 31 * hashCode + (this.getHostPort() == null ? 0 : this.getHostPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        return hashCode;
    }

    public NetworkBinding clone() {
        try {
            return (NetworkBinding)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NetworkBindingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

