/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codebuild.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codebuild.model.EnvironmentLanguage;
import com.amazonaws.services.codebuild.model.PlatformType;
import com.amazonaws.services.codebuild.model.transform.EnvironmentPlatformMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EnvironmentPlatform
implements Serializable,
Cloneable,
StructuredPojo {
    private String platform;
    private List<EnvironmentLanguage> languages;

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    @JsonProperty(value="platform")
    public String getPlatform() {
        return this.platform;
    }

    public EnvironmentPlatform withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    @JsonIgnore
    public void setPlatform(PlatformType platform) {
        this.withPlatform(platform);
    }

    public EnvironmentPlatform withPlatform(PlatformType platform) {
        this.platform = platform.toString();
        return this;
    }

    public List<EnvironmentLanguage> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Collection<EnvironmentLanguage> languages) {
        if (languages == null) {
            this.languages = null;
            return;
        }
        this.languages = new ArrayList<EnvironmentLanguage>(languages);
    }

    public EnvironmentPlatform withLanguages(EnvironmentLanguage ... languages) {
        if (this.languages == null) {
            this.setLanguages(new ArrayList<EnvironmentLanguage>(languages.length));
        }
        for (EnvironmentLanguage ele : languages) {
            this.languages.add(ele);
        }
        return this;
    }

    public EnvironmentPlatform withLanguages(Collection<EnvironmentLanguage> languages) {
        this.setLanguages(languages);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getLanguages() != null) {
            sb.append("Languages: ").append(this.getLanguages());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentPlatform)) {
            return false;
        }
        EnvironmentPlatform other = (EnvironmentPlatform)obj;
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getLanguages() == null ^ this.getLanguages() == null) {
            return false;
        }
        return other.getLanguages() == null || other.getLanguages().equals(this.getLanguages());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getLanguages() == null ? 0 : this.getLanguages().hashCode());
        return hashCode;
    }

    public EnvironmentPlatform clone() {
        try {
            return (EnvironmentPlatform)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EnvironmentPlatformMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

