/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.simplesystemsmanagement.model.DocumentPermissionType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyDocumentPermissionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String permissionType;
    private SdkInternalList<String> accountIdsToAdd;
    private SdkInternalList<String> accountIdsToRemove;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ModifyDocumentPermissionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setPermissionType(String permissionType) {
        this.permissionType = permissionType;
    }

    @JsonProperty(value="permissionType")
    public String getPermissionType() {
        return this.permissionType;
    }

    public ModifyDocumentPermissionRequest withPermissionType(String permissionType) {
        this.setPermissionType(permissionType);
        return this;
    }

    @JsonIgnore
    public void setPermissionType(DocumentPermissionType permissionType) {
        this.withPermissionType(permissionType);
    }

    public ModifyDocumentPermissionRequest withPermissionType(DocumentPermissionType permissionType) {
        this.permissionType = permissionType.toString();
        return this;
    }

    public List<String> getAccountIdsToAdd() {
        if (this.accountIdsToAdd == null) {
            this.accountIdsToAdd = new SdkInternalList();
        }
        return this.accountIdsToAdd;
    }

    public void setAccountIdsToAdd(Collection<String> accountIdsToAdd) {
        if (accountIdsToAdd == null) {
            this.accountIdsToAdd = null;
            return;
        }
        this.accountIdsToAdd = new SdkInternalList<String>(accountIdsToAdd);
    }

    public ModifyDocumentPermissionRequest withAccountIdsToAdd(String ... accountIdsToAdd) {
        if (this.accountIdsToAdd == null) {
            this.setAccountIdsToAdd(new SdkInternalList<String>(accountIdsToAdd.length));
        }
        for (String ele : accountIdsToAdd) {
            this.accountIdsToAdd.add(ele);
        }
        return this;
    }

    public ModifyDocumentPermissionRequest withAccountIdsToAdd(Collection<String> accountIdsToAdd) {
        this.setAccountIdsToAdd(accountIdsToAdd);
        return this;
    }

    public List<String> getAccountIdsToRemove() {
        if (this.accountIdsToRemove == null) {
            this.accountIdsToRemove = new SdkInternalList();
        }
        return this.accountIdsToRemove;
    }

    public void setAccountIdsToRemove(Collection<String> accountIdsToRemove) {
        if (accountIdsToRemove == null) {
            this.accountIdsToRemove = null;
            return;
        }
        this.accountIdsToRemove = new SdkInternalList<String>(accountIdsToRemove);
    }

    public ModifyDocumentPermissionRequest withAccountIdsToRemove(String ... accountIdsToRemove) {
        if (this.accountIdsToRemove == null) {
            this.setAccountIdsToRemove(new SdkInternalList<String>(accountIdsToRemove.length));
        }
        for (String ele : accountIdsToRemove) {
            this.accountIdsToRemove.add(ele);
        }
        return this;
    }

    public ModifyDocumentPermissionRequest withAccountIdsToRemove(Collection<String> accountIdsToRemove) {
        this.setAccountIdsToRemove(accountIdsToRemove);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getPermissionType() != null) {
            sb.append("PermissionType: ").append(this.getPermissionType()).append(",");
        }
        if (this.getAccountIdsToAdd() != null) {
            sb.append("AccountIdsToAdd: ").append(this.getAccountIdsToAdd()).append(",");
        }
        if (this.getAccountIdsToRemove() != null) {
            sb.append("AccountIdsToRemove: ").append(this.getAccountIdsToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDocumentPermissionRequest)) {
            return false;
        }
        ModifyDocumentPermissionRequest other = (ModifyDocumentPermissionRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getPermissionType() == null ^ this.getPermissionType() == null) {
            return false;
        }
        if (other.getPermissionType() != null && !other.getPermissionType().equals(this.getPermissionType())) {
            return false;
        }
        if (other.getAccountIdsToAdd() == null ^ this.getAccountIdsToAdd() == null) {
            return false;
        }
        if (other.getAccountIdsToAdd() != null && !other.getAccountIdsToAdd().equals(this.getAccountIdsToAdd())) {
            return false;
        }
        if (other.getAccountIdsToRemove() == null ^ this.getAccountIdsToRemove() == null) {
            return false;
        }
        return other.getAccountIdsToRemove() == null || other.getAccountIdsToRemove().equals(this.getAccountIdsToRemove());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getPermissionType() == null ? 0 : this.getPermissionType().hashCode());
        hashCode = 31 * hashCode + (this.getAccountIdsToAdd() == null ? 0 : this.getAccountIdsToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getAccountIdsToRemove() == null ? 0 : this.getAccountIdsToRemove().hashCode());
        return hashCode;
    }

    @Override
    public ModifyDocumentPermissionRequest clone() {
        return (ModifyDocumentPermissionRequest)super.clone();
    }
}

