/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.opsworks.model.Architecture;
import com.amazonaws.services.opsworks.model.AutoScalingType;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateInstanceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private SdkInternalList<String> layerIds;
    private String instanceType;
    private String autoScalingType;
    private String hostname;
    private String os;
    private String amiId;
    private String sshKeyName;
    private String architecture;
    private Boolean installUpdatesOnBoot;
    private Boolean ebsOptimized;
    private String agentVersion;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public UpdateInstanceRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public List<String> getLayerIds() {
        if (this.layerIds == null) {
            this.layerIds = new SdkInternalList();
        }
        return this.layerIds;
    }

    public void setLayerIds(Collection<String> layerIds) {
        if (layerIds == null) {
            this.layerIds = null;
            return;
        }
        this.layerIds = new SdkInternalList<String>(layerIds);
    }

    public UpdateInstanceRequest withLayerIds(String ... layerIds) {
        if (this.layerIds == null) {
            this.setLayerIds(new SdkInternalList<String>(layerIds.length));
        }
        for (String ele : layerIds) {
            this.layerIds.add(ele);
        }
        return this;
    }

    public UpdateInstanceRequest withLayerIds(Collection<String> layerIds) {
        this.setLayerIds(layerIds);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public UpdateInstanceRequest withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public void setAutoScalingType(String autoScalingType) {
        this.autoScalingType = autoScalingType;
    }

    @JsonProperty(value="autoScalingType")
    public String getAutoScalingType() {
        return this.autoScalingType;
    }

    public UpdateInstanceRequest withAutoScalingType(String autoScalingType) {
        this.setAutoScalingType(autoScalingType);
        return this;
    }

    @JsonIgnore
    public void setAutoScalingType(AutoScalingType autoScalingType) {
        this.withAutoScalingType(autoScalingType);
    }

    public UpdateInstanceRequest withAutoScalingType(AutoScalingType autoScalingType) {
        this.autoScalingType = autoScalingType.toString();
        return this;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public UpdateInstanceRequest withHostname(String hostname) {
        this.setHostname(hostname);
        return this;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getOs() {
        return this.os;
    }

    public UpdateInstanceRequest withOs(String os) {
        this.setOs(os);
        return this;
    }

    public void setAmiId(String amiId) {
        this.amiId = amiId;
    }

    public String getAmiId() {
        return this.amiId;
    }

    public UpdateInstanceRequest withAmiId(String amiId) {
        this.setAmiId(amiId);
        return this;
    }

    public void setSshKeyName(String sshKeyName) {
        this.sshKeyName = sshKeyName;
    }

    public String getSshKeyName() {
        return this.sshKeyName;
    }

    public UpdateInstanceRequest withSshKeyName(String sshKeyName) {
        this.setSshKeyName(sshKeyName);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    @JsonProperty(value="architecture")
    public String getArchitecture() {
        return this.architecture;
    }

    public UpdateInstanceRequest withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    @JsonIgnore
    public void setArchitecture(Architecture architecture) {
        this.withArchitecture(architecture);
    }

    public UpdateInstanceRequest withArchitecture(Architecture architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    public void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.installUpdatesOnBoot = installUpdatesOnBoot;
    }

    public Boolean getInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public UpdateInstanceRequest withInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
        this.setInstallUpdatesOnBoot(installUpdatesOnBoot);
        return this;
    }

    public Boolean isInstallUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public UpdateInstanceRequest withEbsOptimized(Boolean ebsOptimized) {
        this.setEbsOptimized(ebsOptimized);
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public String getAgentVersion() {
        return this.agentVersion;
    }

    public UpdateInstanceRequest withAgentVersion(String agentVersion) {
        this.setAgentVersion(agentVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getLayerIds() != null) {
            sb.append("LayerIds: ").append(this.getLayerIds()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getAutoScalingType() != null) {
            sb.append("AutoScalingType: ").append(this.getAutoScalingType()).append(",");
        }
        if (this.getHostname() != null) {
            sb.append("Hostname: ").append(this.getHostname()).append(",");
        }
        if (this.getOs() != null) {
            sb.append("Os: ").append(this.getOs()).append(",");
        }
        if (this.getAmiId() != null) {
            sb.append("AmiId: ").append(this.getAmiId()).append(",");
        }
        if (this.getSshKeyName() != null) {
            sb.append("SshKeyName: ").append(this.getSshKeyName()).append(",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: ").append(this.getArchitecture()).append(",");
        }
        if (this.getInstallUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(this.getInstallUpdatesOnBoot()).append(",");
        }
        if (this.getEbsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.getEbsOptimized()).append(",");
        }
        if (this.getAgentVersion() != null) {
            sb.append("AgentVersion: ").append(this.getAgentVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceRequest)) {
            return false;
        }
        UpdateInstanceRequest other = (UpdateInstanceRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getLayerIds() == null ^ this.getLayerIds() == null) {
            return false;
        }
        if (other.getLayerIds() != null && !other.getLayerIds().equals(this.getLayerIds())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getAutoScalingType() == null ^ this.getAutoScalingType() == null) {
            return false;
        }
        if (other.getAutoScalingType() != null && !other.getAutoScalingType().equals(this.getAutoScalingType())) {
            return false;
        }
        if (other.getHostname() == null ^ this.getHostname() == null) {
            return false;
        }
        if (other.getHostname() != null && !other.getHostname().equals(this.getHostname())) {
            return false;
        }
        if (other.getOs() == null ^ this.getOs() == null) {
            return false;
        }
        if (other.getOs() != null && !other.getOs().equals(this.getOs())) {
            return false;
        }
        if (other.getAmiId() == null ^ this.getAmiId() == null) {
            return false;
        }
        if (other.getAmiId() != null && !other.getAmiId().equals(this.getAmiId())) {
            return false;
        }
        if (other.getSshKeyName() == null ^ this.getSshKeyName() == null) {
            return false;
        }
        if (other.getSshKeyName() != null && !other.getSshKeyName().equals(this.getSshKeyName())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getInstallUpdatesOnBoot() == null ^ this.getInstallUpdatesOnBoot() == null) {
            return false;
        }
        if (other.getInstallUpdatesOnBoot() != null && !other.getInstallUpdatesOnBoot().equals(this.getInstallUpdatesOnBoot())) {
            return false;
        }
        if (other.getEbsOptimized() == null ^ this.getEbsOptimized() == null) {
            return false;
        }
        if (other.getEbsOptimized() != null && !other.getEbsOptimized().equals(this.getEbsOptimized())) {
            return false;
        }
        if (other.getAgentVersion() == null ^ this.getAgentVersion() == null) {
            return false;
        }
        return other.getAgentVersion() == null || other.getAgentVersion().equals(this.getAgentVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getLayerIds() == null ? 0 : this.getLayerIds().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingType() == null ? 0 : this.getAutoScalingType().hashCode());
        hashCode = 31 * hashCode + (this.getHostname() == null ? 0 : this.getHostname().hashCode());
        hashCode = 31 * hashCode + (this.getOs() == null ? 0 : this.getOs().hashCode());
        hashCode = 31 * hashCode + (this.getAmiId() == null ? 0 : this.getAmiId().hashCode());
        hashCode = 31 * hashCode + (this.getSshKeyName() == null ? 0 : this.getSshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getInstallUpdatesOnBoot() == null ? 0 : this.getInstallUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.getEbsOptimized() == null ? 0 : this.getEbsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.getAgentVersion() == null ? 0 : this.getAgentVersion().hashCode());
        return hashCode;
    }

    @Override
    public UpdateInstanceRequest clone() {
        return (UpdateInstanceRequest)super.clone();
    }
}

