/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.NetworkMode;
import com.amazonaws.services.ecs.model.TaskDefinitionPlacementConstraint;
import com.amazonaws.services.ecs.model.Volume;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RegisterTaskDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String family;
    private String taskRoleArn;
    private String networkMode;
    private SdkInternalList<ContainerDefinition> containerDefinitions;
    private SdkInternalList<Volume> volumes;
    private SdkInternalList<TaskDefinitionPlacementConstraint> placementConstraints;

    public void setFamily(String family) {
        this.family = family;
    }

    public String getFamily() {
        return this.family;
    }

    public RegisterTaskDefinitionRequest withFamily(String family) {
        this.setFamily(family);
        return this;
    }

    public void setTaskRoleArn(String taskRoleArn) {
        this.taskRoleArn = taskRoleArn;
    }

    public String getTaskRoleArn() {
        return this.taskRoleArn;
    }

    public RegisterTaskDefinitionRequest withTaskRoleArn(String taskRoleArn) {
        this.setTaskRoleArn(taskRoleArn);
        return this;
    }

    public void setNetworkMode(String networkMode) {
        this.networkMode = networkMode;
    }

    @JsonProperty(value="networkMode")
    public String getNetworkMode() {
        return this.networkMode;
    }

    public RegisterTaskDefinitionRequest withNetworkMode(String networkMode) {
        this.setNetworkMode(networkMode);
        return this;
    }

    @JsonIgnore
    public void setNetworkMode(NetworkMode networkMode) {
        this.withNetworkMode(networkMode);
    }

    public RegisterTaskDefinitionRequest withNetworkMode(NetworkMode networkMode) {
        this.networkMode = networkMode.toString();
        return this;
    }

    public List<ContainerDefinition> getContainerDefinitions() {
        if (this.containerDefinitions == null) {
            this.containerDefinitions = new SdkInternalList();
        }
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        this.containerDefinitions = new SdkInternalList<ContainerDefinition>(containerDefinitions);
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(ContainerDefinition ... containerDefinitions) {
        if (this.containerDefinitions == null) {
            this.setContainerDefinitions(new SdkInternalList<ContainerDefinition>(containerDefinitions.length));
        }
        for (ContainerDefinition ele : containerDefinitions) {
            this.containerDefinitions.add(ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        this.setContainerDefinitions(containerDefinitions);
        return this;
    }

    public List<Volume> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new SdkInternalList();
        }
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new SdkInternalList<Volume>(volumes);
    }

    public RegisterTaskDefinitionRequest withVolumes(Volume ... volumes) {
        if (this.volumes == null) {
            this.setVolumes(new SdkInternalList<Volume>(volumes.length));
        }
        for (Volume ele : volumes) {
            this.volumes.add(ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withVolumes(Collection<Volume> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public List<TaskDefinitionPlacementConstraint> getPlacementConstraints() {
        if (this.placementConstraints == null) {
            this.placementConstraints = new SdkInternalList();
        }
        return this.placementConstraints;
    }

    public void setPlacementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
        if (placementConstraints == null) {
            this.placementConstraints = null;
            return;
        }
        this.placementConstraints = new SdkInternalList<TaskDefinitionPlacementConstraint>(placementConstraints);
    }

    public RegisterTaskDefinitionRequest withPlacementConstraints(TaskDefinitionPlacementConstraint ... placementConstraints) {
        if (this.placementConstraints == null) {
            this.setPlacementConstraints(new SdkInternalList<TaskDefinitionPlacementConstraint>(placementConstraints.length));
        }
        for (TaskDefinitionPlacementConstraint ele : placementConstraints) {
            this.placementConstraints.add(ele);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withPlacementConstraints(Collection<TaskDefinitionPlacementConstraint> placementConstraints) {
        this.setPlacementConstraints(placementConstraints);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFamily() != null) {
            sb.append("Family: ").append(this.getFamily()).append(",");
        }
        if (this.getTaskRoleArn() != null) {
            sb.append("TaskRoleArn: ").append(this.getTaskRoleArn()).append(",");
        }
        if (this.getNetworkMode() != null) {
            sb.append("NetworkMode: ").append(this.getNetworkMode()).append(",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: ").append(this.getContainerDefinitions()).append(",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: ").append(this.getVolumes()).append(",");
        }
        if (this.getPlacementConstraints() != null) {
            sb.append("PlacementConstraints: ").append(this.getPlacementConstraints());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskDefinitionRequest)) {
            return false;
        }
        RegisterTaskDefinitionRequest other = (RegisterTaskDefinitionRequest)obj;
        if (other.getFamily() == null ^ this.getFamily() == null) {
            return false;
        }
        if (other.getFamily() != null && !other.getFamily().equals(this.getFamily())) {
            return false;
        }
        if (other.getTaskRoleArn() == null ^ this.getTaskRoleArn() == null) {
            return false;
        }
        if (other.getTaskRoleArn() != null && !other.getTaskRoleArn().equals(this.getTaskRoleArn())) {
            return false;
        }
        if (other.getNetworkMode() == null ^ this.getNetworkMode() == null) {
            return false;
        }
        if (other.getNetworkMode() != null && !other.getNetworkMode().equals(this.getNetworkMode())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        if (other.getContainerDefinitions() != null && !other.getContainerDefinitions().equals(this.getContainerDefinitions())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !other.getVolumes().equals(this.getVolumes())) {
            return false;
        }
        if (other.getPlacementConstraints() == null ^ this.getPlacementConstraints() == null) {
            return false;
        }
        return other.getPlacementConstraints() == null || other.getPlacementConstraints().equals(this.getPlacementConstraints());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFamily() == null ? 0 : this.getFamily().hashCode());
        hashCode = 31 * hashCode + (this.getTaskRoleArn() == null ? 0 : this.getTaskRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkMode() == null ? 0 : this.getNetworkMode().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getPlacementConstraints() == null ? 0 : this.getPlacementConstraints().hashCode());
        return hashCode;
    }

    @Override
    public RegisterTaskDefinitionRequest clone() {
        return (RegisterTaskDefinitionRequest)super.clone();
    }
}

