/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetItemRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String tableName;
    private Map<String, AttributeValue> key;
    private List<String> attributesToGet;
    private Boolean consistentRead;
    private String returnConsumedCapacity;
    private String projectionExpression;
    private Map<String, String> expressionAttributeNames;

    public GetItemRequest() {
    }

    public GetItemRequest(String tableName, Map<String, AttributeValue> key) {
        this.setTableName(tableName);
        this.setKey(key);
    }

    public GetItemRequest(String tableName, Map<String, AttributeValue> key, Boolean consistentRead) {
        this.setTableName(tableName);
        this.setKey(key);
        this.setConsistentRead(consistentRead);
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public GetItemRequest withTableName(String tableName) {
        this.setTableName(tableName);
        return this;
    }

    public Map<String, AttributeValue> getKey() {
        return this.key;
    }

    public void setKey(Map<String, AttributeValue> key) {
        this.key = key;
    }

    public GetItemRequest withKey(Map<String, AttributeValue> key) {
        this.setKey(key);
        return this;
    }

    public GetItemRequest addKeyEntry(String key, AttributeValue value) {
        if (null == this.key) {
            this.key = new HashMap<String, AttributeValue>();
        }
        if (this.key.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.key.put(key, value);
        return this;
    }

    public GetItemRequest clearKeyEntries() {
        this.key = null;
        return this;
    }

    public List<String> getAttributesToGet() {
        return this.attributesToGet;
    }

    public void setAttributesToGet(Collection<String> attributesToGet) {
        if (attributesToGet == null) {
            this.attributesToGet = null;
            return;
        }
        this.attributesToGet = new ArrayList<String>(attributesToGet);
    }

    public GetItemRequest withAttributesToGet(String ... attributesToGet) {
        if (this.attributesToGet == null) {
            this.setAttributesToGet(new ArrayList<String>(attributesToGet.length));
        }
        for (String ele : attributesToGet) {
            this.attributesToGet.add(ele);
        }
        return this;
    }

    public GetItemRequest withAttributesToGet(Collection<String> attributesToGet) {
        this.setAttributesToGet(attributesToGet);
        return this;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public Boolean getConsistentRead() {
        return this.consistentRead;
    }

    public GetItemRequest withConsistentRead(Boolean consistentRead) {
        this.setConsistentRead(consistentRead);
        return this;
    }

    public Boolean isConsistentRead() {
        return this.consistentRead;
    }

    public void setReturnConsumedCapacity(String returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity;
    }

    @JsonProperty(value="returnConsumedCapacity")
    public String getReturnConsumedCapacity() {
        return this.returnConsumedCapacity;
    }

    public GetItemRequest withReturnConsumedCapacity(String returnConsumedCapacity) {
        this.setReturnConsumedCapacity(returnConsumedCapacity);
        return this;
    }

    @JsonIgnore
    public void setReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.withReturnConsumedCapacity(returnConsumedCapacity);
    }

    public GetItemRequest withReturnConsumedCapacity(ReturnConsumedCapacity returnConsumedCapacity) {
        this.returnConsumedCapacity = returnConsumedCapacity.toString();
        return this;
    }

    public void setProjectionExpression(String projectionExpression) {
        this.projectionExpression = projectionExpression;
    }

    public String getProjectionExpression() {
        return this.projectionExpression;
    }

    public GetItemRequest withProjectionExpression(String projectionExpression) {
        this.setProjectionExpression(projectionExpression);
        return this;
    }

    public Map<String, String> getExpressionAttributeNames() {
        return this.expressionAttributeNames;
    }

    public void setExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.expressionAttributeNames = expressionAttributeNames;
    }

    public GetItemRequest withExpressionAttributeNames(Map<String, String> expressionAttributeNames) {
        this.setExpressionAttributeNames(expressionAttributeNames);
        return this;
    }

    public GetItemRequest addExpressionAttributeNamesEntry(String key, String value) {
        if (null == this.expressionAttributeNames) {
            this.expressionAttributeNames = new HashMap<String, String>();
        }
        if (this.expressionAttributeNames.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.expressionAttributeNames.put(key, value);
        return this;
    }

    public GetItemRequest clearExpressionAttributeNamesEntries() {
        this.expressionAttributeNames = null;
        return this;
    }

    public void setKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        if (hashKey == null) {
            throw new IllegalArgumentException("hashKey must be non-null object.");
        }
        key.put(hashKey.getKey(), hashKey.getValue());
        if (rangeKey != null) {
            key.put(rangeKey.getKey(), rangeKey.getValue());
        }
        this.setKey(key);
    }

    public GetItemRequest withKey(Map.Entry<String, AttributeValue> hashKey, Map.Entry<String, AttributeValue> rangeKey) throws IllegalArgumentException {
        this.setKey(hashKey, rangeKey);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTableName() != null) {
            sb.append("TableName: ").append(this.getTableName()).append(",");
        }
        if (this.getKey() != null) {
            sb.append("Key: ").append(this.getKey()).append(",");
        }
        if (this.getAttributesToGet() != null) {
            sb.append("AttributesToGet: ").append(this.getAttributesToGet()).append(",");
        }
        if (this.getConsistentRead() != null) {
            sb.append("ConsistentRead: ").append(this.getConsistentRead()).append(",");
        }
        if (this.getReturnConsumedCapacity() != null) {
            sb.append("ReturnConsumedCapacity: ").append(this.getReturnConsumedCapacity()).append(",");
        }
        if (this.getProjectionExpression() != null) {
            sb.append("ProjectionExpression: ").append(this.getProjectionExpression()).append(",");
        }
        if (this.getExpressionAttributeNames() != null) {
            sb.append("ExpressionAttributeNames: ").append(this.getExpressionAttributeNames());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetItemRequest)) {
            return false;
        }
        GetItemRequest other = (GetItemRequest)obj;
        if (other.getTableName() == null ^ this.getTableName() == null) {
            return false;
        }
        if (other.getTableName() != null && !other.getTableName().equals(this.getTableName())) {
            return false;
        }
        if (other.getKey() == null ^ this.getKey() == null) {
            return false;
        }
        if (other.getKey() != null && !other.getKey().equals(this.getKey())) {
            return false;
        }
        if (other.getAttributesToGet() == null ^ this.getAttributesToGet() == null) {
            return false;
        }
        if (other.getAttributesToGet() != null && !other.getAttributesToGet().equals(this.getAttributesToGet())) {
            return false;
        }
        if (other.getConsistentRead() == null ^ this.getConsistentRead() == null) {
            return false;
        }
        if (other.getConsistentRead() != null && !other.getConsistentRead().equals(this.getConsistentRead())) {
            return false;
        }
        if (other.getReturnConsumedCapacity() == null ^ this.getReturnConsumedCapacity() == null) {
            return false;
        }
        if (other.getReturnConsumedCapacity() != null && !other.getReturnConsumedCapacity().equals(this.getReturnConsumedCapacity())) {
            return false;
        }
        if (other.getProjectionExpression() == null ^ this.getProjectionExpression() == null) {
            return false;
        }
        if (other.getProjectionExpression() != null && !other.getProjectionExpression().equals(this.getProjectionExpression())) {
            return false;
        }
        if (other.getExpressionAttributeNames() == null ^ this.getExpressionAttributeNames() == null) {
            return false;
        }
        return other.getExpressionAttributeNames() == null || other.getExpressionAttributeNames().equals(this.getExpressionAttributeNames());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTableName() == null ? 0 : this.getTableName().hashCode());
        hashCode = 31 * hashCode + (this.getKey() == null ? 0 : this.getKey().hashCode());
        hashCode = 31 * hashCode + (this.getAttributesToGet() == null ? 0 : this.getAttributesToGet().hashCode());
        hashCode = 31 * hashCode + (this.getConsistentRead() == null ? 0 : this.getConsistentRead().hashCode());
        hashCode = 31 * hashCode + (this.getReturnConsumedCapacity() == null ? 0 : this.getReturnConsumedCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getProjectionExpression() == null ? 0 : this.getProjectionExpression().hashCode());
        hashCode = 31 * hashCode + (this.getExpressionAttributeNames() == null ? 0 : this.getExpressionAttributeNames().hashCode());
        return hashCode;
    }

    @Override
    public GetItemRequest clone() {
        return (GetItemRequest)super.clone();
    }
}

