/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeLogGroupsRequestMarshaller
implements Marshaller<Request<DescribeLogGroupsRequest>, DescribeLogGroupsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeLogGroupsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeLogGroupsRequest> marshall(DescribeLogGroupsRequest describeLogGroupsRequest) {
        if (describeLogGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeLogGroupsRequest> request = new DefaultRequest<DescribeLogGroupsRequest>(describeLogGroupsRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.DescribeLogGroups");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeLogGroupsRequest.getLogGroupNamePrefix() != null) {
                jsonGenerator.writeFieldName("logGroupNamePrefix").writeValue(describeLogGroupsRequest.getLogGroupNamePrefix());
            }
            if (describeLogGroupsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeLogGroupsRequest.getNextToken());
            }
            if (describeLogGroupsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(describeLogGroupsRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

