/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.MergeShardsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class MergeShardsRequestMarshaller
implements Marshaller<Request<MergeShardsRequest>, MergeShardsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public MergeShardsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<MergeShardsRequest> marshall(MergeShardsRequest mergeShardsRequest) {
        if (mergeShardsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<MergeShardsRequest> request = new DefaultRequest<MergeShardsRequest>(mergeShardsRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.MergeShards");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (mergeShardsRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(mergeShardsRequest.getStreamName());
            }
            if (mergeShardsRequest.getShardToMerge() != null) {
                jsonGenerator.writeFieldName("ShardToMerge").writeValue(mergeShardsRequest.getShardToMerge());
            }
            if (mergeShardsRequest.getAdjacentShardToMerge() != null) {
                jsonGenerator.writeFieldName("AdjacentShardToMerge").writeValue(mergeShardsRequest.getAdjacentShardToMerge());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

