/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.glacier.model.DataRetrievalPolicy;
import com.amazonaws.services.glacier.model.DataRetrievalRule;
import com.amazonaws.services.glacier.model.transform.DataRetrievalRuleJsonMarshaller;
import java.util.List;

public class DataRetrievalPolicyJsonMarshaller {
    private static DataRetrievalPolicyJsonMarshaller instance;

    public void marshall(DataRetrievalPolicy dataRetrievalPolicy, StructuredJsonGenerator jsonGenerator) {
        if (dataRetrievalPolicy == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            List<DataRetrievalRule> rulesList = dataRetrievalPolicy.getRules();
            if (rulesList != null) {
                jsonGenerator.writeFieldName("Rules");
                jsonGenerator.writeStartArray();
                for (DataRetrievalRule rulesListValue : rulesList) {
                    if (rulesListValue == null) continue;
                    DataRetrievalRuleJsonMarshaller.getInstance().marshall(rulesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static DataRetrievalPolicyJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new DataRetrievalPolicyJsonMarshaller();
        }
        return instance;
    }
}

