/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.gamelift.model.S3Location;

public class S3LocationJsonMarshaller {
    private static S3LocationJsonMarshaller instance;

    public void marshall(S3Location s3Location, StructuredJsonGenerator jsonGenerator) {
        if (s3Location == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (s3Location.getBucket() != null) {
                jsonGenerator.writeFieldName("Bucket").writeValue(s3Location.getBucket());
            }
            if (s3Location.getKey() != null) {
                jsonGenerator.writeFieldName("Key").writeValue(s3Location.getKey());
            }
            if (s3Location.getRoleArn() != null) {
                jsonGenerator.writeFieldName("RoleArn").writeValue(s3Location.getRoleArn());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static S3LocationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new S3LocationJsonMarshaller();
        }
        return instance;
    }
}

