/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.Container;
import com.amazonaws.services.ecs.model.Task;
import com.amazonaws.services.ecs.model.transform.ContainerJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.TaskOverrideJsonMarshaller;

public class TaskJsonMarshaller {
    private static TaskJsonMarshaller instance;

    public void marshall(Task task, StructuredJsonGenerator jsonGenerator) {
        if (task == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList containersList;
            jsonGenerator.writeStartObject();
            if (task.getTaskArn() != null) {
                jsonGenerator.writeFieldName("taskArn").writeValue(task.getTaskArn());
            }
            if (task.getClusterArn() != null) {
                jsonGenerator.writeFieldName("clusterArn").writeValue(task.getClusterArn());
            }
            if (task.getTaskDefinitionArn() != null) {
                jsonGenerator.writeFieldName("taskDefinitionArn").writeValue(task.getTaskDefinitionArn());
            }
            if (task.getContainerInstanceArn() != null) {
                jsonGenerator.writeFieldName("containerInstanceArn").writeValue(task.getContainerInstanceArn());
            }
            if (task.getOverrides() != null) {
                jsonGenerator.writeFieldName("overrides");
                TaskOverrideJsonMarshaller.getInstance().marshall(task.getOverrides(), jsonGenerator);
            }
            if (task.getLastStatus() != null) {
                jsonGenerator.writeFieldName("lastStatus").writeValue(task.getLastStatus());
            }
            if (task.getDesiredStatus() != null) {
                jsonGenerator.writeFieldName("desiredStatus").writeValue(task.getDesiredStatus());
            }
            if (!(containersList = (SdkInternalList)task.getContainers()).isEmpty() || !containersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("containers");
                jsonGenerator.writeStartArray();
                for (Container containersListValue : containersList) {
                    if (containersListValue == null) continue;
                    ContainerJsonMarshaller.getInstance().marshall(containersListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (task.getStartedBy() != null) {
                jsonGenerator.writeFieldName("startedBy").writeValue(task.getStartedBy());
            }
            if (task.getStoppedReason() != null) {
                jsonGenerator.writeFieldName("stoppedReason").writeValue(task.getStoppedReason());
            }
            if (task.getCreatedAt() != null) {
                jsonGenerator.writeFieldName("createdAt").writeValue(task.getCreatedAt());
            }
            if (task.getStartedAt() != null) {
                jsonGenerator.writeFieldName("startedAt").writeValue(task.getStartedAt());
            }
            if (task.getStoppedAt() != null) {
                jsonGenerator.writeFieldName("stoppedAt").writeValue(task.getStoppedAt());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static TaskJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new TaskJsonMarshaller();
        }
        return instance;
    }
}

