/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitoidp.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.cognitoidp.model.SchemaAttributeType;
import com.amazonaws.services.cognitoidp.model.UserPoolType;
import com.amazonaws.services.cognitoidp.model.transform.LambdaConfigTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.SchemaAttributeTypeJsonMarshaller;
import com.amazonaws.services.cognitoidp.model.transform.UserPoolPolicyTypeJsonMarshaller;
import java.util.List;

public class UserPoolTypeJsonMarshaller {
    private static UserPoolTypeJsonMarshaller instance;

    public void marshall(UserPoolType userPoolType, StructuredJsonGenerator jsonGenerator) {
        if (userPoolType == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<String> list;
            List<String> autoVerifiedAttributesList;
            List<SchemaAttributeType> schemaAttributesList;
            jsonGenerator.writeStartObject();
            if (userPoolType.getId() != null) {
                jsonGenerator.writeFieldName("Id").writeValue(userPoolType.getId());
            }
            if (userPoolType.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(userPoolType.getName());
            }
            if (userPoolType.getPolicies() != null) {
                jsonGenerator.writeFieldName("Policies");
                UserPoolPolicyTypeJsonMarshaller.getInstance().marshall(userPoolType.getPolicies(), jsonGenerator);
            }
            if (userPoolType.getLambdaConfig() != null) {
                jsonGenerator.writeFieldName("LambdaConfig");
                LambdaConfigTypeJsonMarshaller.getInstance().marshall(userPoolType.getLambdaConfig(), jsonGenerator);
            }
            if (userPoolType.getStatus() != null) {
                jsonGenerator.writeFieldName("Status").writeValue(userPoolType.getStatus());
            }
            if (userPoolType.getLastModifiedDate() != null) {
                jsonGenerator.writeFieldName("LastModifiedDate").writeValue(userPoolType.getLastModifiedDate());
            }
            if (userPoolType.getCreationDate() != null) {
                jsonGenerator.writeFieldName("CreationDate").writeValue(userPoolType.getCreationDate());
            }
            if ((schemaAttributesList = userPoolType.getSchemaAttributes()) != null) {
                jsonGenerator.writeFieldName("SchemaAttributes");
                jsonGenerator.writeStartArray();
                for (SchemaAttributeType schemaAttributeType : schemaAttributesList) {
                    if (schemaAttributeType == null) continue;
                    SchemaAttributeTypeJsonMarshaller.getInstance().marshall(schemaAttributeType, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((autoVerifiedAttributesList = userPoolType.getAutoVerifiedAttributes()) != null) {
                jsonGenerator.writeFieldName("AutoVerifiedAttributes");
                jsonGenerator.writeStartArray();
                for (String autoVerifiedAttributesListValue : autoVerifiedAttributesList) {
                    if (autoVerifiedAttributesListValue == null) continue;
                    jsonGenerator.writeValue(autoVerifiedAttributesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((list = userPoolType.getAliasAttributes()) != null) {
                jsonGenerator.writeFieldName("AliasAttributes");
                jsonGenerator.writeStartArray();
                for (String aliasAttributesListValue : list) {
                    if (aliasAttributesListValue == null) continue;
                    jsonGenerator.writeValue(aliasAttributesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (userPoolType.getSmsVerificationMessage() != null) {
                jsonGenerator.writeFieldName("SmsVerificationMessage").writeValue(userPoolType.getSmsVerificationMessage());
            }
            if (userPoolType.getEmailVerificationMessage() != null) {
                jsonGenerator.writeFieldName("EmailVerificationMessage").writeValue(userPoolType.getEmailVerificationMessage());
            }
            if (userPoolType.getEmailVerificationSubject() != null) {
                jsonGenerator.writeFieldName("EmailVerificationSubject").writeValue(userPoolType.getEmailVerificationSubject());
            }
            if (userPoolType.getSmsAuthenticationMessage() != null) {
                jsonGenerator.writeFieldName("SmsAuthenticationMessage").writeValue(userPoolType.getSmsAuthenticationMessage());
            }
            if (userPoolType.getMfaConfiguration() != null) {
                jsonGenerator.writeFieldName("MfaConfiguration").writeValue(userPoolType.getMfaConfiguration());
            }
            if (userPoolType.getEstimatedNumberOfUsers() != null) {
                jsonGenerator.writeFieldName("EstimatedNumberOfUsers").writeValue(userPoolType.getEstimatedNumberOfUsers());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static UserPoolTypeJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new UserPoolTypeJsonMarshaller();
        }
        return instance;
    }
}

