/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudformation.model.SignalResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SignalResourceRequestMarshaller
implements Marshaller<Request<SignalResourceRequest>, SignalResourceRequest> {
    @Override
    public Request<SignalResourceRequest> marshall(SignalResourceRequest signalResourceRequest) {
        if (signalResourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<SignalResourceRequest> request = new DefaultRequest<SignalResourceRequest>(signalResourceRequest, "AmazonCloudFormation");
        request.addParameter("Action", "SignalResource");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (signalResourceRequest.getStackName() != null) {
            request.addParameter("StackName", StringUtils.fromString(signalResourceRequest.getStackName()));
        }
        if (signalResourceRequest.getLogicalResourceId() != null) {
            request.addParameter("LogicalResourceId", StringUtils.fromString(signalResourceRequest.getLogicalResourceId()));
        }
        if (signalResourceRequest.getUniqueId() != null) {
            request.addParameter("UniqueId", StringUtils.fromString(signalResourceRequest.getUniqueId()));
        }
        if (signalResourceRequest.getStatus() != null) {
            request.addParameter("Status", StringUtils.fromString(signalResourceRequest.getStatus()));
        }
        return request;
    }
}

