/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codepipeline.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.codepipeline.model.PipelineDeclaration;
import java.util.List;

@SdkInternalApi
public class PipelineDeclarationMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<StructuredPojo> ARTIFACTSTORE_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("artifactStore").build();
    private static final MarshallingInfo<List> STAGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stages").build();
    private static final MarshallingInfo<Integer> VERSION_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final PipelineDeclarationMarshaller instance = new PipelineDeclarationMarshaller();

    public static PipelineDeclarationMarshaller getInstance() {
        return instance;
    }

    public void marshall(PipelineDeclaration pipelineDeclaration, ProtocolMarshaller protocolMarshaller) {
        if (pipelineDeclaration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(pipelineDeclaration.getName(), NAME_BINDING);
            protocolMarshaller.marshall(pipelineDeclaration.getRoleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall(pipelineDeclaration.getArtifactStore(), ARTIFACTSTORE_BINDING);
            protocolMarshaller.marshall(pipelineDeclaration.getStages(), STAGES_BINDING);
            protocolMarshaller.marshall(pipelineDeclaration.getVersion(), VERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

