/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.clouddirectory.model.BatchReadOperation;
import com.amazonaws.services.clouddirectory.model.ConsistencyLevel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchReadRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String directoryArn;
    private List<BatchReadOperation> operations;
    private String consistencyLevel;

    public void setDirectoryArn(String directoryArn) {
        this.directoryArn = directoryArn;
    }

    public String getDirectoryArn() {
        return this.directoryArn;
    }

    public BatchReadRequest withDirectoryArn(String directoryArn) {
        this.setDirectoryArn(directoryArn);
        return this;
    }

    public List<BatchReadOperation> getOperations() {
        return this.operations;
    }

    public void setOperations(Collection<BatchReadOperation> operations) {
        if (operations == null) {
            this.operations = null;
            return;
        }
        this.operations = new ArrayList<BatchReadOperation>(operations);
    }

    public BatchReadRequest withOperations(BatchReadOperation ... operations) {
        if (this.operations == null) {
            this.setOperations(new ArrayList<BatchReadOperation>(operations.length));
        }
        for (BatchReadOperation ele : operations) {
            this.operations.add(ele);
        }
        return this;
    }

    public BatchReadRequest withOperations(Collection<BatchReadOperation> operations) {
        this.setOperations(operations);
        return this;
    }

    public void setConsistencyLevel(String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
    }

    public String getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public BatchReadRequest withConsistencyLevel(String consistencyLevel) {
        this.setConsistencyLevel(consistencyLevel);
        return this;
    }

    public void setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.withConsistencyLevel(consistencyLevel);
    }

    public BatchReadRequest withConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDirectoryArn() != null) {
            sb.append("DirectoryArn: ").append(this.getDirectoryArn()).append(",");
        }
        if (this.getOperations() != null) {
            sb.append("Operations: ").append(this.getOperations()).append(",");
        }
        if (this.getConsistencyLevel() != null) {
            sb.append("ConsistencyLevel: ").append(this.getConsistencyLevel());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReadRequest)) {
            return false;
        }
        BatchReadRequest other = (BatchReadRequest)obj;
        if (other.getDirectoryArn() == null ^ this.getDirectoryArn() == null) {
            return false;
        }
        if (other.getDirectoryArn() != null && !other.getDirectoryArn().equals(this.getDirectoryArn())) {
            return false;
        }
        if (other.getOperations() == null ^ this.getOperations() == null) {
            return false;
        }
        if (other.getOperations() != null && !other.getOperations().equals(this.getOperations())) {
            return false;
        }
        if (other.getConsistencyLevel() == null ^ this.getConsistencyLevel() == null) {
            return false;
        }
        return other.getConsistencyLevel() == null || other.getConsistencyLevel().equals(this.getConsistencyLevel());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDirectoryArn() == null ? 0 : this.getDirectoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getOperations() == null ? 0 : this.getOperations().hashCode());
        hashCode = 31 * hashCode + (this.getConsistencyLevel() == null ? 0 : this.getConsistencyLevel().hashCode());
        return hashCode;
    }

    @Override
    public BatchReadRequest clone() {
        return (BatchReadRequest)super.clone();
    }
}

