/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.shield.model.SummarizedCounter;
import com.amazonaws.services.shield.model.transform.SummarizedAttackVectorMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SummarizedAttackVector
implements Serializable,
Cloneable,
StructuredPojo {
    private String vectorType;
    private List<SummarizedCounter> vectorCounters;

    public void setVectorType(String vectorType) {
        this.vectorType = vectorType;
    }

    public String getVectorType() {
        return this.vectorType;
    }

    public SummarizedAttackVector withVectorType(String vectorType) {
        this.setVectorType(vectorType);
        return this;
    }

    public List<SummarizedCounter> getVectorCounters() {
        return this.vectorCounters;
    }

    public void setVectorCounters(Collection<SummarizedCounter> vectorCounters) {
        if (vectorCounters == null) {
            this.vectorCounters = null;
            return;
        }
        this.vectorCounters = new ArrayList<SummarizedCounter>(vectorCounters);
    }

    public SummarizedAttackVector withVectorCounters(SummarizedCounter ... vectorCounters) {
        if (this.vectorCounters == null) {
            this.setVectorCounters(new ArrayList<SummarizedCounter>(vectorCounters.length));
        }
        for (SummarizedCounter ele : vectorCounters) {
            this.vectorCounters.add(ele);
        }
        return this;
    }

    public SummarizedAttackVector withVectorCounters(Collection<SummarizedCounter> vectorCounters) {
        this.setVectorCounters(vectorCounters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVectorType() != null) {
            sb.append("VectorType: ").append(this.getVectorType()).append(",");
        }
        if (this.getVectorCounters() != null) {
            sb.append("VectorCounters: ").append(this.getVectorCounters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SummarizedAttackVector)) {
            return false;
        }
        SummarizedAttackVector other = (SummarizedAttackVector)obj;
        if (other.getVectorType() == null ^ this.getVectorType() == null) {
            return false;
        }
        if (other.getVectorType() != null && !other.getVectorType().equals(this.getVectorType())) {
            return false;
        }
        if (other.getVectorCounters() == null ^ this.getVectorCounters() == null) {
            return false;
        }
        return other.getVectorCounters() == null || other.getVectorCounters().equals(this.getVectorCounters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVectorType() == null ? 0 : this.getVectorType().hashCode());
        hashCode = 31 * hashCode + (this.getVectorCounters() == null ? 0 : this.getVectorCounters().hashCode());
        return hashCode;
    }

    public SummarizedAttackVector clone() {
        try {
            return (SummarizedAttackVector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SummarizedAttackVectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

