/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.UserBucket;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class UserBucketStaxUnmarshaller
implements Unmarshaller<UserBucket, StaxUnmarshallerContext> {
    private static UserBucketStaxUnmarshaller instance;

    @Override
    public UserBucket unmarshall(StaxUnmarshallerContext context) throws Exception {
        UserBucket userBucket = new UserBucket();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return userBucket;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("S3Bucket", targetDepth)) {
                    userBucket.setS3Bucket(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("S3Key", targetDepth)) continue;
                userBucket.setS3Key(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return userBucket;
    }

    public static UserBucketStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new UserBucketStaxUnmarshaller();
        }
        return instance;
    }
}

