/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CopyImageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CopyImageRequestMarshaller
implements Marshaller<Request<CopyImageRequest>, CopyImageRequest> {
    @Override
    public Request<CopyImageRequest> marshall(CopyImageRequest copyImageRequest) {
        if (copyImageRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CopyImageRequest> request = new DefaultRequest<CopyImageRequest>(copyImageRequest, "AmazonEC2");
        request.addParameter("Action", "CopyImage");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (copyImageRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(copyImageRequest.getClientToken()));
        }
        if (copyImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(copyImageRequest.getDescription()));
        }
        if (copyImageRequest.getEncrypted() != null) {
            request.addParameter("Encrypted", StringUtils.fromBoolean(copyImageRequest.getEncrypted()));
        }
        if (copyImageRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(copyImageRequest.getKmsKeyId()));
        }
        if (copyImageRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(copyImageRequest.getName()));
        }
        if (copyImageRequest.getSourceImageId() != null) {
            request.addParameter("SourceImageId", StringUtils.fromString(copyImageRequest.getSourceImageId()));
        }
        if (copyImageRequest.getSourceRegion() != null) {
            request.addParameter("SourceRegion", StringUtils.fromString(copyImageRequest.getSourceRegion()));
        }
        return request;
    }
}

