/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DescribeCommandsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeCommandsRequestMarshaller
implements Marshaller<Request<DescribeCommandsRequest>, DescribeCommandsRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public DescribeCommandsRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeCommandsRequest> marshall(DescribeCommandsRequest describeCommandsRequest) {
        if (describeCommandsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeCommandsRequest> request = new DefaultRequest<DescribeCommandsRequest>(describeCommandsRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeCommands");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList commandIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeCommandsRequest.getDeploymentId() != null) {
                jsonGenerator.writeFieldName("DeploymentId").writeValue(describeCommandsRequest.getDeploymentId());
            }
            if (describeCommandsRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(describeCommandsRequest.getInstanceId());
            }
            if (!(commandIdsList = (SdkInternalList)describeCommandsRequest.getCommandIds()).isEmpty() || !commandIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("CommandIds");
                jsonGenerator.writeStartArray();
                for (String commandIdsListValue : commandIdsList) {
                    if (commandIdsListValue == null) continue;
                    jsonGenerator.writeValue(commandIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

