/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.iot.model.RegisterCACertificateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class RegisterCACertificateRequestMarshaller
implements Marshaller<Request<RegisterCACertificateRequest>, RegisterCACertificateRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public RegisterCACertificateRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<RegisterCACertificateRequest> marshall(RegisterCACertificateRequest registerCACertificateRequest) {
        if (registerCACertificateRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RegisterCACertificateRequest> request = new DefaultRequest<RegisterCACertificateRequest>(registerCACertificateRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/cacertificate";
        request.setResourcePath(uriResourcePath);
        if (registerCACertificateRequest.getSetAsActive() != null) {
            request.addParameter("setAsActive", StringUtils.fromBoolean(registerCACertificateRequest.getSetAsActive()));
        }
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (registerCACertificateRequest.getCaCertificate() != null) {
                jsonGenerator.writeFieldName("caCertificate").writeValue(registerCACertificateRequest.getCaCertificate());
            }
            if (registerCACertificateRequest.getVerificationCertificate() != null) {
                jsonGenerator.writeFieldName("verificationCertificate").writeValue(registerCACertificateRequest.getVerificationCertificate());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

