/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticsearch.model.AdvancedOptionsStatus;
import com.amazonaws.services.elasticsearch.model.transform.OptionStatusJsonMarshaller;
import java.util.Map;

public class AdvancedOptionsStatusJsonMarshaller {
    private static AdvancedOptionsStatusJsonMarshaller instance;

    public void marshall(AdvancedOptionsStatus advancedOptionsStatus, StructuredJsonGenerator jsonGenerator) {
        if (advancedOptionsStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            Map<String, String> optionsMap = advancedOptionsStatus.getOptions();
            if (optionsMap != null) {
                jsonGenerator.writeFieldName("Options");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> optionsMapValue : optionsMap.entrySet()) {
                    if (optionsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(optionsMapValue.getKey());
                    jsonGenerator.writeValue(optionsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (advancedOptionsStatus.getStatus() != null) {
                jsonGenerator.writeFieldName("Status");
                OptionStatusJsonMarshaller.getInstance().marshall(advancedOptionsStatus.getStatus(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static AdvancedOptionsStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new AdvancedOptionsStatusJsonMarshaller();
        }
        return instance;
    }
}

