/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.services.dynamodbv2.datamodeling.ArgumentMarshaller;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerateStrategy;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBAutoGenerator;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperTableModel;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBTypeConverter;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBVersionAttribute;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ComparisonOperator;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DynamoDBMapperFieldModel<T, V>
implements DynamoDBAutoGenerator<V>,
DynamoDBTypeConverter<AttributeValue, V> {
    private final Id<T> id;
    private final Reflect<T, V> reflect;
    private final DynamoDBTypeConverter<AttributeValue, V> converter;
    private final DynamoDBAttributeType dynamoDBAttributeType;
    private final Properties<V> properties;
    @Deprecated
    private ArgumentMarshaller argumentMarshaller;

    @Deprecated
    public DynamoDBMapperFieldModel(String dynamoDBAttributeName, DynamoDBAttributeType dynamoDBAttributeType, ArgumentMarshaller argumentMarshaller) {
        this.id = new Id<Void>(Void.class, dynamoDBAttributeName);
        this.properties = new Properties.Builder().withAttributeName(dynamoDBAttributeName);
        this.reflect = null;
        this.converter = null;
        this.dynamoDBAttributeType = dynamoDBAttributeType;
        this.argumentMarshaller = argumentMarshaller;
    }

    private DynamoDBMapperFieldModel(Builder<T, V> builder) {
        this.id = ((Builder)builder).id;
        this.properties = ((Builder)builder).properties;
        this.reflect = ((Builder)builder).reflect;
        this.converter = ((Builder)builder).converter;
        this.dynamoDBAttributeType = ((Builder)builder).dynamoDBAttributeType;
    }

    public String getDynamoDBAttributeName() {
        return this.properties.attributeName();
    }

    public DynamoDBAttributeType getDynamoDBAttributeType() {
        return this.dynamoDBAttributeType;
    }

    @Deprecated
    ArgumentMarshaller getArgumentMarshaller() {
        return this.argumentMarshaller;
    }

    public final Id<T> id() {
        return this.id;
    }

    public final String name() {
        return this.properties.attributeName();
    }

    public final V get(T object) {
        try {
            return this.reflect.get(object);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id.format("could not get", new Object[0]), e);
        }
    }

    public final void set(T object, V value) {
        try {
            this.reflect.set(object, value);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id.format("could not set", new Object[0]), e);
        }
    }

    public final boolean canGenerate(T object, DynamoDBMapperConfig.SaveBehavior saveBehavior, DynamoDBMapperTableModel<T> model) {
        if (this.getGenerateStrategy() == null) {
            return false;
        }
        if (DynamoDBAutoGenerateStrategy.ALWAYS == this.getGenerateStrategy()) {
            return true;
        }
        if (this.get(object) != null) {
            return false;
        }
        if (this.anyKey(new KeyType[0])) {
            return true;
        }
        if (saveBehavior == DynamoDBMapperConfig.SaveBehavior.CLOBBER || saveBehavior == DynamoDBMapperConfig.SaveBehavior.UPDATE) {
            return true;
        }
        return model != null && model.anyKeyGeneratable(object, saveBehavior);
    }

    public final boolean versioned() {
        if (this.properties.autoGenerator() != null) {
            return this.properties.autoGenerator().getClass() == DynamoDBVersionAttribute.Generator.class;
        }
        return false;
    }

    @Override
    public final DynamoDBAutoGenerateStrategy getGenerateStrategy() {
        if (this.properties.autoGenerator() != null) {
            return this.properties.autoGenerator().getGenerateStrategy();
        }
        return null;
    }

    @Override
    public final V generate(V currentValue) {
        try {
            return this.properties.autoGenerator().generate(currentValue);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id.format("could not generate", new Object[0]), e);
        }
    }

    @Override
    public final AttributeValue convert(V object) {
        try {
            return this.converter.convert(object);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id.format("could not convert", new Object[0]), e);
        }
    }

    @Override
    public final V unconvert(AttributeValue object) {
        try {
            return this.converter.unconvert(object);
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id.format("could not unconvert", new Object[0]), e);
        }
    }

    public final KeyType keyType() {
        return this.properties.keyType();
    }

    public final List<String> globalSecondaryIndexNames(KeyType keyType) {
        return this.properties.globalSecondaryIndexNames(keyType);
    }

    public final List<String> localSecondaryIndexNames() {
        return this.properties.localSecondaryIndexNames();
    }

    public final boolean anyKey(KeyType ... keyTypes) {
        for (KeyType k : keyTypes.length == 0 ? KeyType.values() : keyTypes) {
            if (this.keyType() == k) {
                return true;
            }
            if (!this.globalSecondaryIndexNames(k).isEmpty()) {
                return true;
            }
            if (KeyType.RANGE != k || this.localSecondaryIndexNames().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public final AttributeDefinition definition() {
        try {
            return new AttributeDefinition(this.name(), ScalarAttributeType.valueOf(this.getDynamoDBAttributeType().name()));
        }
        catch (RuntimeException e) {
            throw new DynamoDBMappingException(this.id.format("must be scalar (B, N, or S) but is " + (Object)((Object)this.getDynamoDBAttributeType()), new Object[0]), e);
        }
    }

    public final AttributeValue generateAndConvert(T object) {
        return this.convert((Object)this.generate(this.get(object)));
    }

    public final AttributeValue getAndConvert(T object) {
        return this.convert((Object)this.get(object));
    }

    public final void unconvertAndSet(T object, AttributeValue value) {
        this.set(object, this.unconvert(value));
    }

    public final Collection<AttributeValue> convertAll(Collection<V> values) {
        ArrayList<AttributeValue> converted = new ArrayList<AttributeValue>(values.size());
        for (V value : values) {
            converted.add((AttributeValue)this.convert((Object)value));
        }
        return converted;
    }

    public final Collection<V> unconvertAll(Collection<AttributeValue> values) {
        ArrayList<V> unconverted = new ArrayList<V>(values.size());
        for (AttributeValue value : values) {
            unconverted.add(this.unconvert(value));
        }
        return unconverted;
    }

    public final ExpectedAttributeValue expectedExists(V value) {
        return new ExpectedAttributeValue().withExists(true).withValue((AttributeValue)this.convert((Object)value));
    }

    public final ExpectedAttributeValue expectedNotExists() {
        return new ExpectedAttributeValue().withExists(false);
    }

    public final ExpectedAttributeValue expectedIfExists(V value) {
        return value == null ? this.expectedNotExists() : this.expectedExists(value);
    }

    public final Condition beginsWith(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.BEGINS_WITH).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition between(V lo, V hi) {
        return new Condition().withComparisonOperator(ComparisonOperator.BETWEEN).withAttributeValueList(new AttributeValue[]{this.convert((Object)lo), this.convert((Object)hi)});
    }

    public final Condition contains(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.CONTAINS).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition eq(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.EQ).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition ge(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.GE).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition gt(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.GT).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition in(V ... values) {
        return new Condition().withComparisonOperator(ComparisonOperator.IN).withAttributeValueList(this.convertAll(Arrays.asList(values)));
    }

    public final Condition in(Collection<V> values) {
        return new Condition().withComparisonOperator(ComparisonOperator.IN).withAttributeValueList(this.convertAll(values));
    }

    public final Condition isNull() {
        return new Condition().withComparisonOperator(ComparisonOperator.NULL);
    }

    public final Condition le(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.LE).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition lt(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.LT).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition ne(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.NE).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition notContains(V value) {
        return new Condition().withComparisonOperator(ComparisonOperator.NOT_CONTAINS).withAttributeValueList(new AttributeValue[]{this.convert((Object)value)});
    }

    public final Condition notNull() {
        return new Condition().withComparisonOperator(ComparisonOperator.NOT_NULL);
    }

    public final Condition betweenAny(V lo, V hi) {
        return lo == null ? (hi == null ? null : this.le(hi)) : (hi == null ? this.ge(lo) : (lo.equals(hi) ? this.eq(lo) : this.between(lo, hi)));
    }

    static final class Builder<T, V> {
        private final Id<T> id;
        private final Properties.Builder<V> properties;
        private DynamoDBTypeConverter<AttributeValue, V> converter;
        private DynamoDBAttributeType dynamoDBAttributeType;
        private Reflect<T, V> reflect;

        public Builder(Id<T> id, Properties<V> defaults) {
            this.properties = new Properties.Builder<V>().with(defaults).withAttributeName(id.name());
            this.id = id;
        }

        public Builder<T, V> with(Reflect<T, V> reflect) {
            this.reflect = reflect;
            return this;
        }

        public Builder<T, V> with(DynamoDBTypeConverter<AttributeValue, V> converter) {
            this.converter = converter;
            return this;
        }

        public Builder<T, V> with(DynamoDBAttributeType dynamoDBAttributeType) {
            this.dynamoDBAttributeType = dynamoDBAttributeType;
            return this;
        }

        public final DynamoDBMapperFieldModel<T, V> build() {
            DynamoDBMapperFieldModel field = new DynamoDBMapperFieldModel(this);
            if (field.keyType() != null && field.getGenerateStrategy() == DynamoDBAutoGenerateStrategy.ALWAYS) {
                throw new DynamoDBMappingException(this.id.format("must not have auto-generated key with ALWAYS strategy", new Object[0]));
            }
            return field;
        }
    }

    static interface Properties<V> {
        public Class<V> targetType();

        public String attributeName();

        public KeyType keyType();

        public List<String> globalSecondaryIndexNames(KeyType var1);

        public List<String> localSecondaryIndexNames();

        public DynamoDBAutoGenerator<V> autoGenerator();

        public static final class Builder<V>
        implements Properties<V> {
            private Map<KeyType, List<String>> gsis = Collections.emptyMap();
            private List<String> lsis = Collections.emptyList();
            private DynamoDBAutoGenerator<V> autoGenerator;
            private String attributeName;
            private Class<V> targetType;
            private KeyType keyType;

            public Builder<V> with(Properties<V> defaults) {
                this.targetType = defaults.targetType();
                this.attributeName = defaults.attributeName();
                this.keyType = defaults.keyType();
                this.autoGenerator = defaults.autoGenerator();
                this.lsis = defaults.localSecondaryIndexNames();
                for (KeyType keyType : KeyType.values()) {
                    List<String> names = defaults.globalSecondaryIndexNames(keyType);
                    if (names.isEmpty()) continue;
                    if (this.gsis.isEmpty()) {
                        this.gsis = new LinkedHashMap<KeyType, List<String>>();
                    }
                    this.gsis.put(keyType, names);
                }
                return this;
            }

            public Builder<V> withTargetType(Class<V> targetType) {
                this.targetType = targetType;
                return this;
            }

            public Builder<V> withAttributeName(String attributeName) {
                this.attributeName = attributeName;
                return this;
            }

            @Override
            public Class<V> targetType() {
                return this.targetType;
            }

            @Override
            public String attributeName() {
                return this.attributeName;
            }

            @Override
            public KeyType keyType() {
                return this.keyType;
            }

            @Override
            public List<String> globalSecondaryIndexNames(KeyType keyType) {
                return this.gsis.containsKey((Object)keyType) ? this.gsis.get((Object)keyType) : Collections.emptyList();
            }

            @Override
            public List<String> localSecondaryIndexNames() {
                return this.lsis;
            }

            @Override
            public DynamoDBAutoGenerator<V> autoGenerator() {
                return this.autoGenerator;
            }
        }
    }

    static interface Reflect<T, V> {
        public Class<V> targetType();

        public V get(T var1);

        public void set(T var1, V var2);
    }

    public static final class Id<T> {
        private final Class<T> type;
        private final String name;

        public Id(Class<T> type, String name) {
            this.type = type;
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public final boolean equals(Object o) {
            return o instanceof Id && ((Id)o).type == this.type && ((Id)o).name.equals(this.name);
        }

        public final int hashCode() {
            return this.type.hashCode() ^ this.name.hashCode();
        }

        public final String toString() {
            return this.type.getName() + "[" + this.name + "]";
        }

        public final String format(String message, Object ... args) {
            if (message != null && args.length > 0) {
                try {
                    message = String.format(message, args);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return "Field " + this + " " + message;
        }
    }

    public static enum DynamoDBAttributeType {
        B,
        N,
        S,
        BS,
        NS,
        SS,
        BOOL,
        NULL,
        L,
        M;

    }
}

