/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.devicefarm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.devicefarm.model.Radios;

@SdkInternalApi
public class RadiosMarshaller {
    private static final MarshallingInfo<Boolean> WIFI_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("wifi").build();
    private static final MarshallingInfo<Boolean> BLUETOOTH_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bluetooth").build();
    private static final MarshallingInfo<Boolean> NFC_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nfc").build();
    private static final MarshallingInfo<Boolean> GPS_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("gps").build();
    private static final RadiosMarshaller instance = new RadiosMarshaller();

    public static RadiosMarshaller getInstance() {
        return instance;
    }

    public void marshall(Radios radios, ProtocolMarshaller protocolMarshaller) {
        if (radios == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(radios.getWifi(), WIFI_BINDING);
            protocolMarshaller.marshall(radios.getBluetooth(), BLUETOOTH_BINDING);
            protocolMarshaller.marshall(radios.getNfc(), NFC_BINDING);
            protocolMarshaller.marshall(radios.getGps(), GPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

