/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.cloudformation.model.DeleteStackInstancesRequest;
import com.amazonaws.services.cloudformation.model.StackSetOperationPreferences;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class DeleteStackInstancesRequestMarshaller
implements Marshaller<Request<DeleteStackInstancesRequest>, DeleteStackInstancesRequest> {
    @Override
    public Request<DeleteStackInstancesRequest> marshall(DeleteStackInstancesRequest deleteStackInstancesRequest) {
        StackSetOperationPreferences operationPreferences;
        SdkInternalList regionsList;
        SdkInternalList accountsList;
        if (deleteStackInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteStackInstancesRequest> request = new DefaultRequest<DeleteStackInstancesRequest>(deleteStackInstancesRequest, "AmazonCloudFormation");
        request.addParameter("Action", "DeleteStackInstances");
        request.addParameter("Version", "2010-05-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteStackInstancesRequest.getStackSetName() != null) {
            request.addParameter("StackSetName", StringUtils.fromString(deleteStackInstancesRequest.getStackSetName()));
        }
        if ((accountsList = (SdkInternalList)deleteStackInstancesRequest.getAccounts()).isEmpty() && !accountsList.isAutoConstruct()) {
            request.addParameter("Accounts", "");
        }
        if (!accountsList.isEmpty() || !accountsList.isAutoConstruct()) {
            int accountsListIndex = 1;
            for (Object accountsListValue : accountsList) {
                if (accountsListValue != null) {
                    request.addParameter("Accounts.member." + accountsListIndex, StringUtils.fromString((String)accountsListValue));
                }
                ++accountsListIndex;
            }
        }
        if ((regionsList = (SdkInternalList)deleteStackInstancesRequest.getRegions()).isEmpty() && !regionsList.isAutoConstruct()) {
            request.addParameter("Regions", "");
        }
        if (!regionsList.isEmpty() || !regionsList.isAutoConstruct()) {
            int regionsListIndex = 1;
            for (String regionsListValue : regionsList) {
                if (regionsListValue != null) {
                    request.addParameter("Regions.member." + regionsListIndex, StringUtils.fromString(regionsListValue));
                }
                ++regionsListIndex;
            }
        }
        if ((operationPreferences = deleteStackInstancesRequest.getOperationPreferences()) != null) {
            SdkInternalList regionOrderList = (SdkInternalList)operationPreferences.getRegionOrder();
            if (regionOrderList.isEmpty() && !regionOrderList.isAutoConstruct()) {
                request.addParameter("OperationPreferences.RegionOrder", "");
            }
            if (!regionOrderList.isEmpty() || !regionOrderList.isAutoConstruct()) {
                int regionOrderListIndex = 1;
                for (String regionOrderListValue : regionOrderList) {
                    if (regionOrderListValue != null) {
                        request.addParameter("OperationPreferences.RegionOrder.member." + regionOrderListIndex, StringUtils.fromString(regionOrderListValue));
                    }
                    ++regionOrderListIndex;
                }
            }
            if (operationPreferences.getFailureToleranceCount() != null) {
                request.addParameter("OperationPreferences.FailureToleranceCount", StringUtils.fromInteger(operationPreferences.getFailureToleranceCount()));
            }
            if (operationPreferences.getFailureTolerancePercentage() != null) {
                request.addParameter("OperationPreferences.FailureTolerancePercentage", StringUtils.fromInteger(operationPreferences.getFailureTolerancePercentage()));
            }
            if (operationPreferences.getMaxConcurrentCount() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentCount", StringUtils.fromInteger(operationPreferences.getMaxConcurrentCount()));
            }
            if (operationPreferences.getMaxConcurrentPercentage() != null) {
                request.addParameter("OperationPreferences.MaxConcurrentPercentage", StringUtils.fromInteger(operationPreferences.getMaxConcurrentPercentage()));
            }
        }
        if (deleteStackInstancesRequest.getRetainStacks() != null) {
            request.addParameter("RetainStacks", StringUtils.fromBoolean(deleteStackInstancesRequest.getRetainStacks()));
        }
        request.addParameter("OperationId", IdempotentUtils.resolveString(deleteStackInstancesRequest.getOperationId()));
        return request;
    }
}

