/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.shield.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.shield.model.TimeRange;
import java.util.Date;

@SdkInternalApi
public class TimeRangeMarshaller {
    private static final MarshallingInfo<Date> FROMINCLUSIVE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FromInclusive").build();
    private static final MarshallingInfo<Date> TOEXCLUSIVE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ToExclusive").build();
    private static final TimeRangeMarshaller instance = new TimeRangeMarshaller();

    public static TimeRangeMarshaller getInstance() {
        return instance;
    }

    public void marshall(TimeRange timeRange, ProtocolMarshaller protocolMarshaller) {
        if (timeRange == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(timeRange.getFromInclusive(), FROMINCLUSIVE_BINDING);
            protocolMarshaller.marshall(timeRange.getToExclusive(), TOEXCLUSIVE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

