/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.elasticache.model.DescribeCacheClustersResult;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;

@SdkInternalApi
class CacheClusterDeleted {
    CacheClusterDeleted() {
    }

    static class IsSnapshottingMatcher
    extends WaiterAcceptor<DescribeCacheClustersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsSnapshottingMatcher() {
        }

        @Override
        public boolean matches(DescribeCacheClustersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"snapshotting\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("CacheClusters")), new JmesPathField("CacheClusterStatus"));
        }
    }

    static class IsRestorefailedMatcher
    extends WaiterAcceptor<DescribeCacheClustersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsRestorefailedMatcher() {
        }

        @Override
        public boolean matches(DescribeCacheClustersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"restore-failed\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("CacheClusters")), new JmesPathField("CacheClusterStatus"));
        }
    }

    static class IsModifyingMatcher
    extends WaiterAcceptor<DescribeCacheClustersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsModifyingMatcher() {
        }

        @Override
        public boolean matches(DescribeCacheClustersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"modifying\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("CacheClusters")), new JmesPathField("CacheClusterStatus"));
        }
    }

    static class IsIncompatiblenetworkMatcher
    extends WaiterAcceptor<DescribeCacheClustersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsIncompatiblenetworkMatcher() {
        }

        @Override
        public boolean matches(DescribeCacheClustersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"incompatible-network\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("CacheClusters")), new JmesPathField("CacheClusterStatus"));
        }
    }

    static class IsCreatingMatcher
    extends WaiterAcceptor<DescribeCacheClustersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsCreatingMatcher() {
        }

        @Override
        public boolean matches(DescribeCacheClustersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"creating\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("CacheClusters")), new JmesPathField("CacheClusterStatus"));
        }
    }

    static class IsAvailableMatcher
    extends WaiterAcceptor<DescribeCacheClustersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsAvailableMatcher() {
        }

        @Override
        public boolean matches(DescribeCacheClustersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"available\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("CacheClusters")), new JmesPathField("CacheClusterStatus"));
        }
    }

    static class IsCacheClusterNotFoundMatcher
    extends WaiterAcceptor<DescribeCacheClustersResult> {
        IsCacheClusterNotFoundMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "CacheClusterNotFound".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }
    }

    static class IsDeletedMatcher
    extends WaiterAcceptor<DescribeCacheClustersResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsDeletedMatcher() {
        }

        @Override
        public boolean matches(DescribeCacheClustersResult result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"deleted\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("CacheClusters")), new JmesPathField("CacheClusterStatus"));
        }
    }
}

