/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.ReservedInstancesConfiguration;
import com.amazonaws.services.ec2.model.transform.ModifyReservedInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ModifyReservedInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ModifyReservedInstancesRequest> {
    private SdkInternalList<String> reservedInstancesIds;
    private String clientToken;
    private SdkInternalList<ReservedInstancesConfiguration> targetConfigurations;

    public List<String> getReservedInstancesIds() {
        if (this.reservedInstancesIds == null) {
            this.reservedInstancesIds = new SdkInternalList();
        }
        return this.reservedInstancesIds;
    }

    public void setReservedInstancesIds(Collection<String> reservedInstancesIds) {
        if (reservedInstancesIds == null) {
            this.reservedInstancesIds = null;
            return;
        }
        this.reservedInstancesIds = new SdkInternalList<String>(reservedInstancesIds);
    }

    public ModifyReservedInstancesRequest withReservedInstancesIds(String ... reservedInstancesIds) {
        if (this.reservedInstancesIds == null) {
            this.setReservedInstancesIds(new SdkInternalList<String>(reservedInstancesIds.length));
        }
        for (String ele : reservedInstancesIds) {
            this.reservedInstancesIds.add(ele);
        }
        return this;
    }

    public ModifyReservedInstancesRequest withReservedInstancesIds(Collection<String> reservedInstancesIds) {
        this.setReservedInstancesIds(reservedInstancesIds);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public ModifyReservedInstancesRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<ReservedInstancesConfiguration> getTargetConfigurations() {
        if (this.targetConfigurations == null) {
            this.targetConfigurations = new SdkInternalList();
        }
        return this.targetConfigurations;
    }

    public void setTargetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
        if (targetConfigurations == null) {
            this.targetConfigurations = null;
            return;
        }
        this.targetConfigurations = new SdkInternalList<ReservedInstancesConfiguration>(targetConfigurations);
    }

    public ModifyReservedInstancesRequest withTargetConfigurations(ReservedInstancesConfiguration ... targetConfigurations) {
        if (this.targetConfigurations == null) {
            this.setTargetConfigurations(new SdkInternalList<ReservedInstancesConfiguration>(targetConfigurations.length));
        }
        for (ReservedInstancesConfiguration ele : targetConfigurations) {
            this.targetConfigurations.add(ele);
        }
        return this;
    }

    public ModifyReservedInstancesRequest withTargetConfigurations(Collection<ReservedInstancesConfiguration> targetConfigurations) {
        this.setTargetConfigurations(targetConfigurations);
        return this;
    }

    @Override
    public Request<ModifyReservedInstancesRequest> getDryRunRequest() {
        Request<ModifyReservedInstancesRequest> request = new ModifyReservedInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReservedInstancesIds() != null) {
            sb.append("ReservedInstancesIds: ").append(this.getReservedInstancesIds()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTargetConfigurations() != null) {
            sb.append("TargetConfigurations: ").append(this.getTargetConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyReservedInstancesRequest)) {
            return false;
        }
        ModifyReservedInstancesRequest other = (ModifyReservedInstancesRequest)obj;
        if (other.getReservedInstancesIds() == null ^ this.getReservedInstancesIds() == null) {
            return false;
        }
        if (other.getReservedInstancesIds() != null && !other.getReservedInstancesIds().equals(this.getReservedInstancesIds())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTargetConfigurations() == null ^ this.getTargetConfigurations() == null) {
            return false;
        }
        return other.getTargetConfigurations() == null || other.getTargetConfigurations().equals(this.getTargetConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReservedInstancesIds() == null ? 0 : this.getReservedInstancesIds().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTargetConfigurations() == null ? 0 : this.getTargetConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public ModifyReservedInstancesRequest clone() {
        return (ModifyReservedInstancesRequest)super.clone();
    }
}

