/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.directory.AWSDirectoryServiceAsync;
import com.amazonaws.services.directory.AWSDirectoryServiceAsyncClientBuilder;
import com.amazonaws.services.directory.AWSDirectoryServiceClient;
import com.amazonaws.services.directory.model.AddIpRoutesRequest;
import com.amazonaws.services.directory.model.AddIpRoutesResult;
import com.amazonaws.services.directory.model.AddTagsToResourceRequest;
import com.amazonaws.services.directory.model.AddTagsToResourceResult;
import com.amazonaws.services.directory.model.CancelSchemaExtensionRequest;
import com.amazonaws.services.directory.model.CancelSchemaExtensionResult;
import com.amazonaws.services.directory.model.ConnectDirectoryRequest;
import com.amazonaws.services.directory.model.ConnectDirectoryResult;
import com.amazonaws.services.directory.model.CreateAliasRequest;
import com.amazonaws.services.directory.model.CreateAliasResult;
import com.amazonaws.services.directory.model.CreateComputerRequest;
import com.amazonaws.services.directory.model.CreateComputerResult;
import com.amazonaws.services.directory.model.CreateConditionalForwarderRequest;
import com.amazonaws.services.directory.model.CreateConditionalForwarderResult;
import com.amazonaws.services.directory.model.CreateDirectoryRequest;
import com.amazonaws.services.directory.model.CreateDirectoryResult;
import com.amazonaws.services.directory.model.CreateMicrosoftADRequest;
import com.amazonaws.services.directory.model.CreateMicrosoftADResult;
import com.amazonaws.services.directory.model.CreateSnapshotRequest;
import com.amazonaws.services.directory.model.CreateSnapshotResult;
import com.amazonaws.services.directory.model.CreateTrustRequest;
import com.amazonaws.services.directory.model.CreateTrustResult;
import com.amazonaws.services.directory.model.DeleteConditionalForwarderRequest;
import com.amazonaws.services.directory.model.DeleteConditionalForwarderResult;
import com.amazonaws.services.directory.model.DeleteDirectoryRequest;
import com.amazonaws.services.directory.model.DeleteDirectoryResult;
import com.amazonaws.services.directory.model.DeleteSnapshotRequest;
import com.amazonaws.services.directory.model.DeleteSnapshotResult;
import com.amazonaws.services.directory.model.DeleteTrustRequest;
import com.amazonaws.services.directory.model.DeleteTrustResult;
import com.amazonaws.services.directory.model.DeregisterEventTopicRequest;
import com.amazonaws.services.directory.model.DeregisterEventTopicResult;
import com.amazonaws.services.directory.model.DescribeConditionalForwardersRequest;
import com.amazonaws.services.directory.model.DescribeConditionalForwardersResult;
import com.amazonaws.services.directory.model.DescribeDirectoriesRequest;
import com.amazonaws.services.directory.model.DescribeDirectoriesResult;
import com.amazonaws.services.directory.model.DescribeDomainControllersRequest;
import com.amazonaws.services.directory.model.DescribeDomainControllersResult;
import com.amazonaws.services.directory.model.DescribeEventTopicsRequest;
import com.amazonaws.services.directory.model.DescribeEventTopicsResult;
import com.amazonaws.services.directory.model.DescribeSnapshotsRequest;
import com.amazonaws.services.directory.model.DescribeSnapshotsResult;
import com.amazonaws.services.directory.model.DescribeTrustsRequest;
import com.amazonaws.services.directory.model.DescribeTrustsResult;
import com.amazonaws.services.directory.model.DisableRadiusRequest;
import com.amazonaws.services.directory.model.DisableRadiusResult;
import com.amazonaws.services.directory.model.DisableSsoRequest;
import com.amazonaws.services.directory.model.DisableSsoResult;
import com.amazonaws.services.directory.model.EnableRadiusRequest;
import com.amazonaws.services.directory.model.EnableRadiusResult;
import com.amazonaws.services.directory.model.EnableSsoRequest;
import com.amazonaws.services.directory.model.EnableSsoResult;
import com.amazonaws.services.directory.model.GetDirectoryLimitsRequest;
import com.amazonaws.services.directory.model.GetDirectoryLimitsResult;
import com.amazonaws.services.directory.model.GetSnapshotLimitsRequest;
import com.amazonaws.services.directory.model.GetSnapshotLimitsResult;
import com.amazonaws.services.directory.model.ListIpRoutesRequest;
import com.amazonaws.services.directory.model.ListIpRoutesResult;
import com.amazonaws.services.directory.model.ListSchemaExtensionsRequest;
import com.amazonaws.services.directory.model.ListSchemaExtensionsResult;
import com.amazonaws.services.directory.model.ListTagsForResourceRequest;
import com.amazonaws.services.directory.model.ListTagsForResourceResult;
import com.amazonaws.services.directory.model.RegisterEventTopicRequest;
import com.amazonaws.services.directory.model.RegisterEventTopicResult;
import com.amazonaws.services.directory.model.RemoveIpRoutesRequest;
import com.amazonaws.services.directory.model.RemoveIpRoutesResult;
import com.amazonaws.services.directory.model.RemoveTagsFromResourceRequest;
import com.amazonaws.services.directory.model.RemoveTagsFromResourceResult;
import com.amazonaws.services.directory.model.RestoreFromSnapshotRequest;
import com.amazonaws.services.directory.model.RestoreFromSnapshotResult;
import com.amazonaws.services.directory.model.StartSchemaExtensionRequest;
import com.amazonaws.services.directory.model.StartSchemaExtensionResult;
import com.amazonaws.services.directory.model.UpdateConditionalForwarderRequest;
import com.amazonaws.services.directory.model.UpdateConditionalForwarderResult;
import com.amazonaws.services.directory.model.UpdateNumberOfDomainControllersRequest;
import com.amazonaws.services.directory.model.UpdateNumberOfDomainControllersResult;
import com.amazonaws.services.directory.model.UpdateRadiusRequest;
import com.amazonaws.services.directory.model.UpdateRadiusResult;
import com.amazonaws.services.directory.model.VerifyTrustRequest;
import com.amazonaws.services.directory.model.VerifyTrustResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSDirectoryServiceAsyncClient
extends AWSDirectoryServiceClient
implements AWSDirectoryServiceAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AWSDirectoryServiceAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AWSDirectoryServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSDirectoryServiceAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSDirectoryServiceAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSDirectoryServiceAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AWSDirectoryServiceAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AWSDirectoryServiceAsyncClientBuilder asyncBuilder() {
        return AWSDirectoryServiceAsyncClientBuilder.standard();
    }

    AWSDirectoryServiceAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AddIpRoutesResult> addIpRoutesAsync(AddIpRoutesRequest request) {
        return this.addIpRoutesAsync(request, null);
    }

    @Override
    public Future<AddIpRoutesResult> addIpRoutesAsync(AddIpRoutesRequest request, final AsyncHandler<AddIpRoutesRequest, AddIpRoutesResult> asyncHandler) {
        final AddIpRoutesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddIpRoutesResult>(){

            @Override
            public AddIpRoutesResult call() throws Exception {
                AddIpRoutesResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeAddIpRoutes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request) {
        return this.addTagsToResourceAsync(request, null);
    }

    @Override
    public Future<AddTagsToResourceResult> addTagsToResourceAsync(AddTagsToResourceRequest request, final AsyncHandler<AddTagsToResourceRequest, AddTagsToResourceResult> asyncHandler) {
        final AddTagsToResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AddTagsToResourceResult>(){

            @Override
            public AddTagsToResourceResult call() throws Exception {
                AddTagsToResourceResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeAddTagsToResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CancelSchemaExtensionResult> cancelSchemaExtensionAsync(CancelSchemaExtensionRequest request) {
        return this.cancelSchemaExtensionAsync(request, null);
    }

    @Override
    public Future<CancelSchemaExtensionResult> cancelSchemaExtensionAsync(CancelSchemaExtensionRequest request, final AsyncHandler<CancelSchemaExtensionRequest, CancelSchemaExtensionResult> asyncHandler) {
        final CancelSchemaExtensionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelSchemaExtensionResult>(){

            @Override
            public CancelSchemaExtensionResult call() throws Exception {
                CancelSchemaExtensionResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeCancelSchemaExtension(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ConnectDirectoryResult> connectDirectoryAsync(ConnectDirectoryRequest request) {
        return this.connectDirectoryAsync(request, null);
    }

    @Override
    public Future<ConnectDirectoryResult> connectDirectoryAsync(ConnectDirectoryRequest request, final AsyncHandler<ConnectDirectoryRequest, ConnectDirectoryResult> asyncHandler) {
        final ConnectDirectoryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ConnectDirectoryResult>(){

            @Override
            public ConnectDirectoryResult call() throws Exception {
                ConnectDirectoryResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeConnectDirectory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest request) {
        return this.createAliasAsync(request, null);
    }

    @Override
    public Future<CreateAliasResult> createAliasAsync(CreateAliasRequest request, final AsyncHandler<CreateAliasRequest, CreateAliasResult> asyncHandler) {
        final CreateAliasRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateAliasResult>(){

            @Override
            public CreateAliasResult call() throws Exception {
                CreateAliasResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeCreateAlias(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateComputerResult> createComputerAsync(CreateComputerRequest request) {
        return this.createComputerAsync(request, null);
    }

    @Override
    public Future<CreateComputerResult> createComputerAsync(CreateComputerRequest request, final AsyncHandler<CreateComputerRequest, CreateComputerResult> asyncHandler) {
        final CreateComputerRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateComputerResult>(){

            @Override
            public CreateComputerResult call() throws Exception {
                CreateComputerResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeCreateComputer(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateConditionalForwarderResult> createConditionalForwarderAsync(CreateConditionalForwarderRequest request) {
        return this.createConditionalForwarderAsync(request, null);
    }

    @Override
    public Future<CreateConditionalForwarderResult> createConditionalForwarderAsync(CreateConditionalForwarderRequest request, final AsyncHandler<CreateConditionalForwarderRequest, CreateConditionalForwarderResult> asyncHandler) {
        final CreateConditionalForwarderRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateConditionalForwarderResult>(){

            @Override
            public CreateConditionalForwarderResult call() throws Exception {
                CreateConditionalForwarderResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeCreateConditionalForwarder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateDirectoryResult> createDirectoryAsync(CreateDirectoryRequest request) {
        return this.createDirectoryAsync(request, null);
    }

    @Override
    public Future<CreateDirectoryResult> createDirectoryAsync(CreateDirectoryRequest request, final AsyncHandler<CreateDirectoryRequest, CreateDirectoryResult> asyncHandler) {
        final CreateDirectoryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateDirectoryResult>(){

            @Override
            public CreateDirectoryResult call() throws Exception {
                CreateDirectoryResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeCreateDirectory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateMicrosoftADResult> createMicrosoftADAsync(CreateMicrosoftADRequest request) {
        return this.createMicrosoftADAsync(request, null);
    }

    @Override
    public Future<CreateMicrosoftADResult> createMicrosoftADAsync(CreateMicrosoftADRequest request, final AsyncHandler<CreateMicrosoftADRequest, CreateMicrosoftADResult> asyncHandler) {
        final CreateMicrosoftADRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateMicrosoftADResult>(){

            @Override
            public CreateMicrosoftADResult call() throws Exception {
                CreateMicrosoftADResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeCreateMicrosoftAD(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request) {
        return this.createSnapshotAsync(request, null);
    }

    @Override
    public Future<CreateSnapshotResult> createSnapshotAsync(CreateSnapshotRequest request, final AsyncHandler<CreateSnapshotRequest, CreateSnapshotResult> asyncHandler) {
        final CreateSnapshotRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateSnapshotResult>(){

            @Override
            public CreateSnapshotResult call() throws Exception {
                CreateSnapshotResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeCreateSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateTrustResult> createTrustAsync(CreateTrustRequest request) {
        return this.createTrustAsync(request, null);
    }

    @Override
    public Future<CreateTrustResult> createTrustAsync(CreateTrustRequest request, final AsyncHandler<CreateTrustRequest, CreateTrustResult> asyncHandler) {
        final CreateTrustRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateTrustResult>(){

            @Override
            public CreateTrustResult call() throws Exception {
                CreateTrustResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeCreateTrust(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteConditionalForwarderResult> deleteConditionalForwarderAsync(DeleteConditionalForwarderRequest request) {
        return this.deleteConditionalForwarderAsync(request, null);
    }

    @Override
    public Future<DeleteConditionalForwarderResult> deleteConditionalForwarderAsync(DeleteConditionalForwarderRequest request, final AsyncHandler<DeleteConditionalForwarderRequest, DeleteConditionalForwarderResult> asyncHandler) {
        final DeleteConditionalForwarderRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteConditionalForwarderResult>(){

            @Override
            public DeleteConditionalForwarderResult call() throws Exception {
                DeleteConditionalForwarderResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDeleteConditionalForwarder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteDirectoryResult> deleteDirectoryAsync(DeleteDirectoryRequest request) {
        return this.deleteDirectoryAsync(request, null);
    }

    @Override
    public Future<DeleteDirectoryResult> deleteDirectoryAsync(DeleteDirectoryRequest request, final AsyncHandler<DeleteDirectoryRequest, DeleteDirectoryResult> asyncHandler) {
        final DeleteDirectoryRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteDirectoryResult>(){

            @Override
            public DeleteDirectoryResult call() throws Exception {
                DeleteDirectoryResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDeleteDirectory(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return this.deleteSnapshotAsync(request, null);
    }

    @Override
    public Future<DeleteSnapshotResult> deleteSnapshotAsync(DeleteSnapshotRequest request, final AsyncHandler<DeleteSnapshotRequest, DeleteSnapshotResult> asyncHandler) {
        final DeleteSnapshotRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteSnapshotResult>(){

            @Override
            public DeleteSnapshotResult call() throws Exception {
                DeleteSnapshotResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDeleteSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteTrustResult> deleteTrustAsync(DeleteTrustRequest request) {
        return this.deleteTrustAsync(request, null);
    }

    @Override
    public Future<DeleteTrustResult> deleteTrustAsync(DeleteTrustRequest request, final AsyncHandler<DeleteTrustRequest, DeleteTrustResult> asyncHandler) {
        final DeleteTrustRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteTrustResult>(){

            @Override
            public DeleteTrustResult call() throws Exception {
                DeleteTrustResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDeleteTrust(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeregisterEventTopicResult> deregisterEventTopicAsync(DeregisterEventTopicRequest request) {
        return this.deregisterEventTopicAsync(request, null);
    }

    @Override
    public Future<DeregisterEventTopicResult> deregisterEventTopicAsync(DeregisterEventTopicRequest request, final AsyncHandler<DeregisterEventTopicRequest, DeregisterEventTopicResult> asyncHandler) {
        final DeregisterEventTopicRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeregisterEventTopicResult>(){

            @Override
            public DeregisterEventTopicResult call() throws Exception {
                DeregisterEventTopicResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDeregisterEventTopic(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeConditionalForwardersResult> describeConditionalForwardersAsync(DescribeConditionalForwardersRequest request) {
        return this.describeConditionalForwardersAsync(request, null);
    }

    @Override
    public Future<DescribeConditionalForwardersResult> describeConditionalForwardersAsync(DescribeConditionalForwardersRequest request, final AsyncHandler<DescribeConditionalForwardersRequest, DescribeConditionalForwardersResult> asyncHandler) {
        final DescribeConditionalForwardersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeConditionalForwardersResult>(){

            @Override
            public DescribeConditionalForwardersResult call() throws Exception {
                DescribeConditionalForwardersResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDescribeConditionalForwarders(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync(DescribeDirectoriesRequest request) {
        return this.describeDirectoriesAsync(request, null);
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync(DescribeDirectoriesRequest request, final AsyncHandler<DescribeDirectoriesRequest, DescribeDirectoriesResult> asyncHandler) {
        final DescribeDirectoriesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDirectoriesResult>(){

            @Override
            public DescribeDirectoriesResult call() throws Exception {
                DescribeDirectoriesResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDescribeDirectories(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync() {
        return this.describeDirectoriesAsync(new DescribeDirectoriesRequest());
    }

    @Override
    public Future<DescribeDirectoriesResult> describeDirectoriesAsync(AsyncHandler<DescribeDirectoriesRequest, DescribeDirectoriesResult> asyncHandler) {
        return this.describeDirectoriesAsync(new DescribeDirectoriesRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeDomainControllersResult> describeDomainControllersAsync(DescribeDomainControllersRequest request) {
        return this.describeDomainControllersAsync(request, null);
    }

    @Override
    public Future<DescribeDomainControllersResult> describeDomainControllersAsync(DescribeDomainControllersRequest request, final AsyncHandler<DescribeDomainControllersRequest, DescribeDomainControllersResult> asyncHandler) {
        final DescribeDomainControllersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeDomainControllersResult>(){

            @Override
            public DescribeDomainControllersResult call() throws Exception {
                DescribeDomainControllersResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDescribeDomainControllers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeEventTopicsResult> describeEventTopicsAsync(DescribeEventTopicsRequest request) {
        return this.describeEventTopicsAsync(request, null);
    }

    @Override
    public Future<DescribeEventTopicsResult> describeEventTopicsAsync(DescribeEventTopicsRequest request, final AsyncHandler<DescribeEventTopicsRequest, DescribeEventTopicsResult> asyncHandler) {
        final DescribeEventTopicsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeEventTopicsResult>(){

            @Override
            public DescribeEventTopicsResult call() throws Exception {
                DescribeEventTopicsResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDescribeEventTopics(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request) {
        return this.describeSnapshotsAsync(request, null);
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(DescribeSnapshotsRequest request, final AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        final DescribeSnapshotsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSnapshotsResult>(){

            @Override
            public DescribeSnapshotsResult call() throws Exception {
                DescribeSnapshotsResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDescribeSnapshots(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync() {
        return this.describeSnapshotsAsync(new DescribeSnapshotsRequest());
    }

    @Override
    public Future<DescribeSnapshotsResult> describeSnapshotsAsync(AsyncHandler<DescribeSnapshotsRequest, DescribeSnapshotsResult> asyncHandler) {
        return this.describeSnapshotsAsync(new DescribeSnapshotsRequest(), asyncHandler);
    }

    @Override
    public Future<DescribeTrustsResult> describeTrustsAsync(DescribeTrustsRequest request) {
        return this.describeTrustsAsync(request, null);
    }

    @Override
    public Future<DescribeTrustsResult> describeTrustsAsync(DescribeTrustsRequest request, final AsyncHandler<DescribeTrustsRequest, DescribeTrustsResult> asyncHandler) {
        final DescribeTrustsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeTrustsResult>(){

            @Override
            public DescribeTrustsResult call() throws Exception {
                DescribeTrustsResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDescribeTrusts(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableRadiusResult> disableRadiusAsync(DisableRadiusRequest request) {
        return this.disableRadiusAsync(request, null);
    }

    @Override
    public Future<DisableRadiusResult> disableRadiusAsync(DisableRadiusRequest request, final AsyncHandler<DisableRadiusRequest, DisableRadiusResult> asyncHandler) {
        final DisableRadiusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableRadiusResult>(){

            @Override
            public DisableRadiusResult call() throws Exception {
                DisableRadiusResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDisableRadius(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisableSsoResult> disableSsoAsync(DisableSsoRequest request) {
        return this.disableSsoAsync(request, null);
    }

    @Override
    public Future<DisableSsoResult> disableSsoAsync(DisableSsoRequest request, final AsyncHandler<DisableSsoRequest, DisableSsoResult> asyncHandler) {
        final DisableSsoRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisableSsoResult>(){

            @Override
            public DisableSsoResult call() throws Exception {
                DisableSsoResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeDisableSso(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableRadiusResult> enableRadiusAsync(EnableRadiusRequest request) {
        return this.enableRadiusAsync(request, null);
    }

    @Override
    public Future<EnableRadiusResult> enableRadiusAsync(EnableRadiusRequest request, final AsyncHandler<EnableRadiusRequest, EnableRadiusResult> asyncHandler) {
        final EnableRadiusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableRadiusResult>(){

            @Override
            public EnableRadiusResult call() throws Exception {
                EnableRadiusResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeEnableRadius(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<EnableSsoResult> enableSsoAsync(EnableSsoRequest request) {
        return this.enableSsoAsync(request, null);
    }

    @Override
    public Future<EnableSsoResult> enableSsoAsync(EnableSsoRequest request, final AsyncHandler<EnableSsoRequest, EnableSsoResult> asyncHandler) {
        final EnableSsoRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<EnableSsoResult>(){

            @Override
            public EnableSsoResult call() throws Exception {
                EnableSsoResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeEnableSso(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync(GetDirectoryLimitsRequest request) {
        return this.getDirectoryLimitsAsync(request, null);
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync(GetDirectoryLimitsRequest request, final AsyncHandler<GetDirectoryLimitsRequest, GetDirectoryLimitsResult> asyncHandler) {
        final GetDirectoryLimitsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetDirectoryLimitsResult>(){

            @Override
            public GetDirectoryLimitsResult call() throws Exception {
                GetDirectoryLimitsResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeGetDirectoryLimits(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync() {
        return this.getDirectoryLimitsAsync(new GetDirectoryLimitsRequest());
    }

    @Override
    public Future<GetDirectoryLimitsResult> getDirectoryLimitsAsync(AsyncHandler<GetDirectoryLimitsRequest, GetDirectoryLimitsResult> asyncHandler) {
        return this.getDirectoryLimitsAsync(new GetDirectoryLimitsRequest(), asyncHandler);
    }

    @Override
    public Future<GetSnapshotLimitsResult> getSnapshotLimitsAsync(GetSnapshotLimitsRequest request) {
        return this.getSnapshotLimitsAsync(request, null);
    }

    @Override
    public Future<GetSnapshotLimitsResult> getSnapshotLimitsAsync(GetSnapshotLimitsRequest request, final AsyncHandler<GetSnapshotLimitsRequest, GetSnapshotLimitsResult> asyncHandler) {
        final GetSnapshotLimitsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSnapshotLimitsResult>(){

            @Override
            public GetSnapshotLimitsResult call() throws Exception {
                GetSnapshotLimitsResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeGetSnapshotLimits(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListIpRoutesResult> listIpRoutesAsync(ListIpRoutesRequest request) {
        return this.listIpRoutesAsync(request, null);
    }

    @Override
    public Future<ListIpRoutesResult> listIpRoutesAsync(ListIpRoutesRequest request, final AsyncHandler<ListIpRoutesRequest, ListIpRoutesResult> asyncHandler) {
        final ListIpRoutesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListIpRoutesResult>(){

            @Override
            public ListIpRoutesResult call() throws Exception {
                ListIpRoutesResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeListIpRoutes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSchemaExtensionsResult> listSchemaExtensionsAsync(ListSchemaExtensionsRequest request) {
        return this.listSchemaExtensionsAsync(request, null);
    }

    @Override
    public Future<ListSchemaExtensionsResult> listSchemaExtensionsAsync(ListSchemaExtensionsRequest request, final AsyncHandler<ListSchemaExtensionsRequest, ListSchemaExtensionsResult> asyncHandler) {
        final ListSchemaExtensionsRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSchemaExtensionsResult>(){

            @Override
            public ListSchemaExtensionsResult call() throws Exception {
                ListSchemaExtensionsResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeListSchemaExtensions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {
        return this.listTagsForResourceAsync(request, null);
    }

    @Override
    public Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request, final AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {
        final ListTagsForResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListTagsForResourceResult>(){

            @Override
            public ListTagsForResourceResult call() throws Exception {
                ListTagsForResourceResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeListTagsForResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RegisterEventTopicResult> registerEventTopicAsync(RegisterEventTopicRequest request) {
        return this.registerEventTopicAsync(request, null);
    }

    @Override
    public Future<RegisterEventTopicResult> registerEventTopicAsync(RegisterEventTopicRequest request, final AsyncHandler<RegisterEventTopicRequest, RegisterEventTopicResult> asyncHandler) {
        final RegisterEventTopicRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RegisterEventTopicResult>(){

            @Override
            public RegisterEventTopicResult call() throws Exception {
                RegisterEventTopicResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeRegisterEventTopic(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveIpRoutesResult> removeIpRoutesAsync(RemoveIpRoutesRequest request) {
        return this.removeIpRoutesAsync(request, null);
    }

    @Override
    public Future<RemoveIpRoutesResult> removeIpRoutesAsync(RemoveIpRoutesRequest request, final AsyncHandler<RemoveIpRoutesRequest, RemoveIpRoutesResult> asyncHandler) {
        final RemoveIpRoutesRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveIpRoutesResult>(){

            @Override
            public RemoveIpRoutesResult call() throws Exception {
                RemoveIpRoutesResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeRemoveIpRoutes(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request) {
        return this.removeTagsFromResourceAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromResourceResult> removeTagsFromResourceAsync(RemoveTagsFromResourceRequest request, final AsyncHandler<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResult> asyncHandler) {
        final RemoveTagsFromResourceRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RemoveTagsFromResourceResult>(){

            @Override
            public RemoveTagsFromResourceResult call() throws Exception {
                RemoveTagsFromResourceResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeRemoveTagsFromResource(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RestoreFromSnapshotResult> restoreFromSnapshotAsync(RestoreFromSnapshotRequest request) {
        return this.restoreFromSnapshotAsync(request, null);
    }

    @Override
    public Future<RestoreFromSnapshotResult> restoreFromSnapshotAsync(RestoreFromSnapshotRequest request, final AsyncHandler<RestoreFromSnapshotRequest, RestoreFromSnapshotResult> asyncHandler) {
        final RestoreFromSnapshotRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<RestoreFromSnapshotResult>(){

            @Override
            public RestoreFromSnapshotResult call() throws Exception {
                RestoreFromSnapshotResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeRestoreFromSnapshot(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSchemaExtensionResult> startSchemaExtensionAsync(StartSchemaExtensionRequest request) {
        return this.startSchemaExtensionAsync(request, null);
    }

    @Override
    public Future<StartSchemaExtensionResult> startSchemaExtensionAsync(StartSchemaExtensionRequest request, final AsyncHandler<StartSchemaExtensionRequest, StartSchemaExtensionResult> asyncHandler) {
        final StartSchemaExtensionRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSchemaExtensionResult>(){

            @Override
            public StartSchemaExtensionResult call() throws Exception {
                StartSchemaExtensionResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeStartSchemaExtension(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateConditionalForwarderResult> updateConditionalForwarderAsync(UpdateConditionalForwarderRequest request) {
        return this.updateConditionalForwarderAsync(request, null);
    }

    @Override
    public Future<UpdateConditionalForwarderResult> updateConditionalForwarderAsync(UpdateConditionalForwarderRequest request, final AsyncHandler<UpdateConditionalForwarderRequest, UpdateConditionalForwarderResult> asyncHandler) {
        final UpdateConditionalForwarderRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateConditionalForwarderResult>(){

            @Override
            public UpdateConditionalForwarderResult call() throws Exception {
                UpdateConditionalForwarderResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeUpdateConditionalForwarder(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateNumberOfDomainControllersResult> updateNumberOfDomainControllersAsync(UpdateNumberOfDomainControllersRequest request) {
        return this.updateNumberOfDomainControllersAsync(request, null);
    }

    @Override
    public Future<UpdateNumberOfDomainControllersResult> updateNumberOfDomainControllersAsync(UpdateNumberOfDomainControllersRequest request, final AsyncHandler<UpdateNumberOfDomainControllersRequest, UpdateNumberOfDomainControllersResult> asyncHandler) {
        final UpdateNumberOfDomainControllersRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateNumberOfDomainControllersResult>(){

            @Override
            public UpdateNumberOfDomainControllersResult call() throws Exception {
                UpdateNumberOfDomainControllersResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeUpdateNumberOfDomainControllers(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateRadiusResult> updateRadiusAsync(UpdateRadiusRequest request) {
        return this.updateRadiusAsync(request, null);
    }

    @Override
    public Future<UpdateRadiusResult> updateRadiusAsync(UpdateRadiusRequest request, final AsyncHandler<UpdateRadiusRequest, UpdateRadiusResult> asyncHandler) {
        final UpdateRadiusRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateRadiusResult>(){

            @Override
            public UpdateRadiusResult call() throws Exception {
                UpdateRadiusResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeUpdateRadius(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<VerifyTrustResult> verifyTrustAsync(VerifyTrustRequest request) {
        return this.verifyTrustAsync(request, null);
    }

    @Override
    public Future<VerifyTrustResult> verifyTrustAsync(VerifyTrustRequest request, final AsyncHandler<VerifyTrustRequest, VerifyTrustResult> asyncHandler) {
        final VerifyTrustRequest finalRequest = this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<VerifyTrustResult>(){

            @Override
            public VerifyTrustResult call() throws Exception {
                VerifyTrustResult result = null;
                try {
                    result = AWSDirectoryServiceAsyncClient.this.executeVerifyTrust(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(finalRequest, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

