/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.Service;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ServiceMarshaller {
    private static final MarshallingInfo<Integer> REFERENCEID_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReferenceId").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<List> NAMES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Names").build();
    private static final MarshallingInfo<Boolean> ROOT_BINDING = MarshallingInfo.builder(MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Root").build();
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").build();
    private static final MarshallingInfo<List> EDGES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Edges").build();
    private static final MarshallingInfo<StructuredPojo> SUMMARYSTATISTICS_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SummaryStatistics").build();
    private static final MarshallingInfo<List> DURATIONHISTOGRAM_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DurationHistogram").build();
    private static final MarshallingInfo<List> RESPONSETIMEHISTOGRAM_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResponseTimeHistogram").build();
    private static final ServiceMarshaller instance = new ServiceMarshaller();

    public static ServiceMarshaller getInstance() {
        return instance;
    }

    public void marshall(Service service, ProtocolMarshaller protocolMarshaller) {
        if (service == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(service.getReferenceId(), REFERENCEID_BINDING);
            protocolMarshaller.marshall(service.getName(), NAME_BINDING);
            protocolMarshaller.marshall(service.getNames(), NAMES_BINDING);
            protocolMarshaller.marshall(service.getRoot(), ROOT_BINDING);
            protocolMarshaller.marshall(service.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall(service.getType(), TYPE_BINDING);
            protocolMarshaller.marshall(service.getState(), STATE_BINDING);
            protocolMarshaller.marshall(service.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall(service.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall(service.getEdges(), EDGES_BINDING);
            protocolMarshaller.marshall(service.getSummaryStatistics(), SUMMARYSTATISTICS_BINDING);
            protocolMarshaller.marshall(service.getDurationHistogram(), DURATIONHISTOGRAM_BINDING);
            protocolMarshaller.marshall(service.getResponseTimeHistogram(), RESPONSETIMEHISTOGRAM_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

